/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.i18n.core;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;
import xyz.erupt.annotation.EruptI18n;
import xyz.erupt.core.context.MetaContext;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.core.view.EruptBuildModel;
import xyz.erupt.core.view.EruptFieldModel;
import xyz.erupt.core.view.EruptModel;
import xyz.erupt.i18n.core.I18nProcess;

@Aspect
@Component
public class EruptBuildAop {
    private static final String LANG_HEADER = "lang";
    private final String POINT_CUT = "execution(public * xyz.erupt.core.controller.EruptBuildController.getEruptBuild(..))";
    @Resource
    private HttpServletRequest request;

    @AfterReturning(pointcut="execution(public * xyz.erupt.core.controller.EruptBuildController.getEruptBuild(..))", returning="eruptBuildModel")
    public void doAfterReturning(EruptBuildModel eruptBuildModel) {
        if (StringUtils.isNotBlank((CharSequence)this.request.getHeader(LANG_HEADER))) {
            Optional.ofNullable(EruptCoreService.getErupt((String)MetaContext.getErupt().getName()).getClazz()).ifPresent(eruptClass -> {
                EruptI18n eruptI18n = eruptClass.getAnnotation(EruptI18n.class);
                if (null != eruptI18n && eruptI18n.enable()) {
                    Optional.ofNullable(I18nProcess.getLangMapping(this.request.getHeader(LANG_HEADER).toLowerCase())).ifPresent(it -> {
                        this.process(eruptBuildModel.getEruptModel(), (Properties)it);
                        if (null != eruptBuildModel.getOperationErupts()) {
                            eruptBuildModel.getOperationErupts().values().forEach(eruptModel -> this.process((EruptModel)eruptModel, (Properties)it));
                        }
                        if (null != eruptBuildModel.getTabErupts()) {
                            eruptBuildModel.getTabErupts().values().forEach(eruptModel -> this.process(eruptModel.getEruptModel(), (Properties)it));
                        }
                    });
                }
            });
        }
    }

    private void process(EruptModel eruptModel, Properties langMapping) {
        eruptModel.setEruptJson(eruptModel.getEruptJson().deepCopy());
        JsonObject eruptJson = eruptModel.getEruptJson();
        if (eruptJson.has("rowOperation")) {
            for (JsonElement rowOperation : eruptJson.getAsJsonArray("rowOperation")) {
                this.convert(langMapping, rowOperation.getAsJsonObject(), "title");
                this.convert(langMapping, rowOperation.getAsJsonObject(), "tip");
            }
        }
        if (eruptJson.has("rowOperation")) {
            for (JsonElement drill : eruptJson.getAsJsonArray("drills")) {
                this.convert(langMapping, drill.getAsJsonObject(), "title");
            }
        }
        for (EruptFieldModel fieldModel : eruptModel.getEruptFieldModels()) {
            fieldModel.setEruptFieldJson(fieldModel.getEruptFieldJson().deepCopy());
            JsonObject eruptFieldJson = fieldModel.getEruptFieldJson();
            if (eruptFieldJson.has("edit")) {
                JsonObject edit = eruptFieldJson.getAsJsonObject("edit");
                this.convert(langMapping, edit, "title");
                this.convert(langMapping, edit, "desc");
            }
            if (!eruptFieldJson.has("views")) continue;
            for (JsonElement view : eruptFieldJson.getAsJsonArray("views")) {
                this.convert(langMapping, view.getAsJsonObject(), "title");
                this.convert(langMapping, view.getAsJsonObject(), "desc");
            }
        }
    }

    public void convert(Properties langMapping, JsonObject element, String replaceKey) {
        String value = element.get(replaceKey).getAsString();
        if (StringUtils.isNotBlank((CharSequence)value) && langMapping.containsKey(value)) {
            element.addProperty(replaceKey, langMapping.get(value).toString());
        }
    }
}

