/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.i18n.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Service;
import xyz.erupt.core.service.I18NTranslateService;

@Service
public class I18nProcess
extends HashMap<String, Properties>
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(I18nProcess.class);
    private static final I18nProcess langMappings = new I18nProcess();
    private static final String I18N_EXT = "properties";
    @Resource
    private I18NTranslateService i18NTranslateService;

    public static Properties getLangMapping(String lang) {
        return (Properties)langMappings.get(lang);
    }

    public void run(ApplicationArguments args) {
        Enumeration<URL> urls = I18nProcess.class.getClassLoader().getResources("i18n/");
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            switch (url.getProtocol()) {
                case "file": {
                    this.scanFile(new File(URLDecoder.decode(url.getFile(), Charset.defaultCharset().name())));
                    break;
                }
                case "jar": {
                    JarURLConnection urlConnection = (JarURLConnection)url.openConnection();
                    this.scanJar(urlConnection.getJarFile());
                }
            }
        }
        this.i18NTranslateService.registerI18NMapping((Map)langMappings);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanFile(File file) {
        block14: {
            if (file.isFile()) {
                String fileName = file.getAbsolutePath();
                if (!fileName.endsWith(I18N_EXT)) break block14;
                String lang = this.getFileLang(fileName);
                Properties properties = new Properties();
                FileInputStream fileInputStream = new FileInputStream(file);
                try {
                    InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, StandardCharsets.UTF_8);
                    try {
                        properties.load(inputStreamReader);
                        if (langMappings.containsKey(lang)) {
                            ((Properties)langMappings.get(lang)).putAll((Map<?, ?>)properties);
                        } else {
                            langMappings.put(lang, properties);
                        }
                        break block14;
                    }
                    finally {
                        if (Collections.singletonList(inputStreamReader).get(0) != null) {
                            inputStreamReader.close();
                        }
                    }
                }
                finally {
                    if (Collections.singletonList(fileInputStream).get(0) != null) {
                        fileInputStream.close();
                    }
                }
            }
            if (file.isDirectory()) {
                Optional.ofNullable(file.listFiles()).ifPresent(files -> Arrays.stream(files).forEach(this::scanFile));
            }
        }
    }

    private void scanJar(JarFile jar) {
        Enumeration<JarEntry> jarEntryEnumeration = jar.entries();
        while (jarEntryEnumeration.hasMoreElements()) {
            JarEntry entry = jarEntryEnumeration.nextElement();
            if (!entry.getName().endsWith(I18N_EXT)) continue;
            String lang = this.getFileLang(entry.getName());
            Properties properties = new Properties();
            try (InputStreamReader inputStreamReader = new InputStreamReader(jar.getInputStream(entry), StandardCharsets.UTF_8);){
                properties.load(inputStreamReader);
                if (langMappings.containsKey(lang)) {
                    ((Properties)langMappings.get(lang)).putAll((Map<?, ?>)properties);
                    continue;
                }
                langMappings.put(lang, properties);
            }
        }
    }

    private String getFileLang(String fileName) {
        fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
        String[] split = fileName.substring(0, fileName.indexOf(I18N_EXT) - 1).split("_");
        return split[split.length - 1].toLowerCase();
    }
}

