/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.job.service;

import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import xyz.erupt.job.config.EruptJobProp;
import xyz.erupt.job.model.EruptJob;
import xyz.erupt.job.service.EruptJobService;
import xyz.erupt.jpa.dao.EruptDao;

@Service
@Order
public class JobStartService {
    private static final Logger log = LoggerFactory.getLogger(JobStartService.class);
    @Resource
    private EruptDao eruptDao;
    @Resource
    private EruptJobService eruptJobService;
    @Resource
    private EruptJobProp eruptJobProp;

    public void run() {
        if (this.eruptJobProp.isEnable()) {
            for (EruptJob job : this.eruptDao.queryEntityList(EruptJob.class, "status = true", null)) {
                this.eruptJobService.modifyJob(job);
            }
        } else {
            log.info("Erupt job disable");
        }
    }
}

