/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.job.service;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Service;
import xyz.erupt.annotation.fun.VLModel;
import xyz.erupt.core.annotation.EruptHandlerNaming;
import xyz.erupt.core.service.EruptApplication;
import xyz.erupt.core.toolkit.TimeRecorder;
import xyz.erupt.core.util.EruptSpringUtil;
import xyz.erupt.job.config.EruptJobProp;
import xyz.erupt.job.handler.EruptJobHandler;
import xyz.erupt.job.model.EruptJob;
import xyz.erupt.job.service.EruptJobService;
import xyz.erupt.jpa.dao.EruptDao;

@Service
@Order
public class JobStartService
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(JobStartService.class);
    @Resource
    private EruptDao eruptDao;
    @Resource
    private EruptJobService eruptJobService;
    @Resource
    private EruptJobProp eruptJobProp;
    private static final List<VLModel> loadedJobHandler = new ArrayList<VLModel>();

    public static List<VLModel> getLoadedJobHandler() {
        return loadedJobHandler;
    }

    @Transactional
    public void run(String ... args) throws Exception {
        TimeRecorder timeRecorder = new TimeRecorder();
        EruptSpringUtil.scannerPackage((String[])EruptApplication.getScanPackage(), (TypeFilter[])new TypeFilter[]{new AssignableTypeFilter(EruptJobHandler.class)}, clazz -> {
            EruptHandlerNaming eruptHandlerNaming = clazz.getAnnotation(EruptHandlerNaming.class);
            loadedJobHandler.add(new VLModel(clazz.getName(), null == eruptHandlerNaming ? clazz.getSimpleName() : eruptHandlerNaming.value()));
        });
        if (this.eruptJobProp.isEnable()) {
            for (EruptJob job : this.eruptDao.queryEntityList(EruptJob.class, "status = true", null)) {
                this.eruptJobService.modifyJob(job);
            }
            log.info("Erupt job initialization completed in {} ms", (Object)timeRecorder.recorder());
        } else {
            log.info("Erupt job disable");
        }
    }
}

