/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.job.service;

import java.text.ParseException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.simpl.SimpleThreadPool;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.stereotype.Service;
import xyz.erupt.job.model.EruptJob;
import xyz.erupt.job.model.EruptJobLog;
import xyz.erupt.job.service.EruptJobAction;
import xyz.erupt.jpa.dao.EruptDao;

@Service
public class EruptJobService
implements DisposableBean {
    private static final String PROP_THREAD_COUNT = "org.quartz.threadPool.threadCount";
    private static final int DEFAULT_THREAD_COUNT = 1;
    @Resource
    private EruptDao eruptDao;
    @Autowired(required=false)
    private JavaMailSenderImpl javaMailSender;
    @Resource
    StringRedisTemplate stringRedisTemplate;
    public static final String MAIL_SENDER_KEY = "mailSensor";
    private final Map<String, EruptJobStdSchedulerFactory> schedulerFactoryMap = new ConcurrentHashMap<String, EruptJobStdSchedulerFactory>();

    public void triggerJob(EruptJob eruptJob) {
        new EruptJobAction().trigger(eruptJob, this.javaMailSender);
    }

    public synchronized void addJob(EruptJob eruptJob) throws SchedulerException, ParseException {
        String code = eruptJob.getCode();
        if (!this.schedulerFactoryMap.containsKey(code) && eruptJob.getStatus().booleanValue()) {
            StdSchedulerFactory ssf = new StdSchedulerFactory();
            ssf.initialize(this.getSchedulerProp(code));
            Scheduler scheduler = ssf.getScheduler();
            JobDetailImpl job = new JobDetailImpl();
            JobDataMap jobDataMap = new JobDataMap();
            jobDataMap.put(code, (Object)eruptJob);
            jobDataMap.put(MAIL_SENDER_KEY, (Object)this.javaMailSender);
            job.setJobDataMap(jobDataMap);
            job.setName(code);
            job.setJobClass(EruptJobAction.class);
            CronTriggerImpl trigger = new CronTriggerImpl();
            trigger.setName(code);
            trigger.setCronExpression(eruptJob.getCron());
            scheduler.scheduleJob((JobDetail)job, (Trigger)trigger);
            scheduler.start();
            this.schedulerFactoryMap.put(code, new EruptJobStdSchedulerFactory(eruptJob, ssf));
        }
    }

    public synchronized void modifyJob(EruptJob eruptJob) throws SchedulerException, ParseException {
        if (this.schedulerFactoryMap.containsKey(eruptJob.getCode())) {
            if (eruptJob.equals((Object)this.schedulerFactoryMap.get(eruptJob.getCode()).getEruptJob())) {
                return;
            }
            this.deleteJob(eruptJob);
        }
        this.addJob(eruptJob);
    }

    public synchronized void deleteJob(EruptJob eruptJob) throws SchedulerException {
        EruptJobStdSchedulerFactory sf = this.schedulerFactoryMap.get(eruptJob.getCode());
        if (null != sf) {
            Scheduler scheduler = sf.getStdSchedulerFactory().getScheduler();
            scheduler.deleteJob(new JobKey(eruptJob.getCode()));
            if (!scheduler.isShutdown()) {
                scheduler.shutdown();
            }
            this.schedulerFactoryMap.remove(eruptJob.getCode());
        }
    }

    private Properties getSchedulerProp(String schedulerName) {
        Properties props = new Properties();
        props.setProperty("org.quartz.scheduler.makeSchedulerThreadDaemon", "true");
        props.setProperty("org.quartz.scheduler.interruptJobsOnShutdownWithWait", "true");
        props.setProperty("org.quartz.scheduler.interruptJobsOnShutdown", "true");
        props.setProperty("org.quartz.scheduler.instanceId", "AUTO");
        props.setProperty("org.quartz.scheduler.instanceName", schedulerName);
        props.setProperty("org.quartz.threadPool.class", SimpleThreadPool.class.getName());
        props.setProperty(PROP_THREAD_COUNT, Integer.toString(1));
        return props;
    }

    public void saveJobLog(EruptJobLog eruptJobLog) {
        this.eruptDao.persistAndFlush((Object)eruptJobLog);
    }

    public void destroy() throws SchedulerException {
        for (EruptJobStdSchedulerFactory value : this.schedulerFactoryMap.values()) {
            value.getStdSchedulerFactory().getScheduler().shutdown();
        }
    }

    public StringRedisTemplate getStringRedisTemplate() {
        return this.stringRedisTemplate;
    }

    private static class EruptJobStdSchedulerFactory {
        private EruptJob eruptJob;
        private StdSchedulerFactory stdSchedulerFactory;

        public EruptJobStdSchedulerFactory(EruptJob eruptJob, StdSchedulerFactory stdSchedulerFactory) {
            this.eruptJob = eruptJob;
            this.stdSchedulerFactory = stdSchedulerFactory;
        }

        public EruptJob getEruptJob() {
            return this.eruptJob;
        }

        public StdSchedulerFactory getStdSchedulerFactory() {
            return this.stdSchedulerFactory;
        }

        public void setEruptJob(EruptJob eruptJob) {
            this.eruptJob = eruptJob;
        }

        public void setStdSchedulerFactory(StdSchedulerFactory stdSchedulerFactory) {
            this.stdSchedulerFactory = stdSchedulerFactory;
        }

        public EruptJobStdSchedulerFactory() {
        }
    }
}

