/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.job.model.data_proxy;

import java.text.ParseException;
import java.util.List;
import javax.annotation.Resource;
import javax.persistence.Transient;
import org.quartz.SchedulerException;
import org.springframework.stereotype.Service;
import xyz.erupt.annotation.fun.DataProxy;
import xyz.erupt.annotation.fun.OperationHandler;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.core.util.Erupts;
import xyz.erupt.job.model.EruptJob;
import xyz.erupt.job.service.EruptJobService;

@Service
public class EruptJobDataProxy
implements DataProxy<EruptJob>,
OperationHandler<EruptJob, Void> {
    @Transient
    @Resource
    private EruptJobService eruptJobService;

    public void addBehavior(EruptJob eruptJob) {
        eruptJob.setStatus(true);
    }

    public void beforeAdd(EruptJob eruptJob) {
        if (null == eruptJob.getCode()) {
            eruptJob.setCode(Erupts.generateCode());
        }
        try {
            this.eruptJobService.modifyJob(eruptJob);
        }
        catch (ParseException | SchedulerException e) {
            throw new EruptWebApiRuntimeException(e.getMessage());
        }
    }

    public void beforeUpdate(EruptJob eruptJob) {
        this.beforeAdd(eruptJob);
    }

    public void beforeDelete(EruptJob eruptJob) {
        try {
            this.eruptJobService.deleteJob(eruptJob);
        }
        catch (SchedulerException e) {
            throw new EruptWebApiRuntimeException(e.getMessage());
        }
    }

    public String exec(List<EruptJob> eruptJob, Void param, String[] operationParam) {
        try {
            for (EruptJob job : eruptJob) {
                this.eruptJobService.triggerJob(job);
            }
            return null;
        }
        catch (Exception e) {
            throw new EruptWebApiRuntimeException(e.getMessage());
        }
    }
}

