/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.job.service;

import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import xyz.erupt.core.util.EruptSpringUtil;
import xyz.erupt.job.handler.EruptJobHandler;
import xyz.erupt.job.model.EruptJob;
import xyz.erupt.job.model.EruptJobLog;
import xyz.erupt.job.service.EruptJobService;

public class EruptJobAction
implements Job {
    private static final Logger log = LoggerFactory.getLogger(EruptJobAction.class);

    public void execute(JobExecutionContext ctx) {
        JobDataMap jobDataMap = ctx.getJobDetail().getJobDataMap();
        EruptJob eruptJob = (EruptJob)((Object)jobDataMap.get((Object)ctx.getJobDetail().getKey().getName()));
        this.trigger(eruptJob, (JavaMailSenderImpl)jobDataMap.get((Object)"mailSensor"));
    }

    void trigger(EruptJob eruptJob, JavaMailSenderImpl javaMailSender) {
        String handler = eruptJob.getHandler();
        EruptJobLog eruptJobLog = new EruptJobLog();
        if (StringUtils.isNotBlank((CharSequence)handler)) {
            block5: {
                eruptJobLog.setEruptJob(eruptJob);
                eruptJobLog.setStartTime(new Date());
                EruptJobHandler jobHandler = null;
                try {
                    jobHandler = (EruptJobHandler)EruptSpringUtil.getBeanByPath((String)eruptJob.getHandler(), EruptJobHandler.class);
                    String result = jobHandler.exec(eruptJob.getCode(), eruptJob.getHandlerParam());
                    jobHandler.success(result, eruptJob.getHandlerParam());
                    eruptJobLog.setResultInfo(result);
                    eruptJobLog.setStatus(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    eruptJobLog.setStatus(false);
                    String exceptionTraceStr = ExceptionUtils.getStackTrace((Throwable)e);
                    eruptJobLog.setErrorInfo(exceptionTraceStr);
                    if (null != jobHandler) {
                        jobHandler.error(e, eruptJob.getHandlerParam());
                    }
                    if (!StringUtils.isNotBlank((CharSequence)eruptJob.getNotifyEmails())) break block5;
                    if (null == javaMailSender) {
                        log.warn("Sending mailbox not configured");
                    }
                    SimpleMailMessage message = new SimpleMailMessage();
                    message.setSubject(eruptJob.getName() + " job error \uff01\uff01\uff01");
                    message.setText(exceptionTraceStr);
                    message.setTo(eruptJob.getNotifyEmails().split("\\|"));
                    message.setFrom(Objects.requireNonNull(javaMailSender.getUsername()));
                    javaMailSender.send(message);
                }
            }
            eruptJobLog.setHandlerParam(eruptJob.getHandlerParam());
            eruptJobLog.setEndTime(new Date());
            ((EruptJobService)EruptSpringUtil.getBean(EruptJobService.class)).saveJobLog(eruptJobLog);
        }
    }
}

