/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.job.model.data_proxy;

import java.text.ParseException;
import java.util.List;
import javax.annotation.Resource;
import javax.persistence.Transient;
import org.quartz.SchedulerException;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.springframework.stereotype.Service;
import xyz.erupt.annotation.fun.DataProxy;
import xyz.erupt.annotation.fun.OperationHandler;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.core.util.Erupts;
import xyz.erupt.job.model.EruptJob;
import xyz.erupt.job.model.data_proxy.EruptJobExecDialog;
import xyz.erupt.job.service.EruptJobService;
import xyz.erupt.jpa.dao.EruptDao;

@Service
public class EruptJobDataProcess
implements DataProxy<EruptJob>,
OperationHandler<EruptJob, EruptJobExecDialog> {
    @Transient
    @Resource
    private EruptJobService eruptJobService;
    @Resource
    private EruptDao eruptDao;

    public void beforeAdd(EruptJob eruptJob) {
        CronTriggerImpl trigger = new CronTriggerImpl();
        try {
            trigger.setCronExpression(eruptJob.getCron());
        }
        catch (Exception e) {
            throw new EruptWebApiRuntimeException("Cron error " + e.getMessage(), (Throwable)e);
        }
    }

    public void beforeUpdate(EruptJob eruptJob) {
        this.beforeAdd(eruptJob);
    }

    public void afterAdd(EruptJob eruptJob) {
        try {
            this.eruptJobService.addJob(eruptJob);
        }
        catch (ParseException | SchedulerException e) {
            throw new EruptWebApiRuntimeException(e.getMessage());
        }
    }

    public void afterUpdate(EruptJob eruptJob) {
        try {
            this.eruptJobService.modifyJob(eruptJob);
        }
        catch (ParseException | SchedulerException e) {
            throw new EruptWebApiRuntimeException(e.getMessage());
        }
    }

    public void afterDelete(EruptJob eruptJob) {
        try {
            this.eruptJobService.deleteJob(eruptJob);
        }
        catch (SchedulerException e) {
            throw new EruptWebApiRuntimeException(e.getMessage());
        }
    }

    public String exec(List<EruptJob> eruptJob, EruptJobExecDialog param, String[] operationParam) {
        try {
            for (EruptJob job : eruptJob) {
                this.eruptDao.detach((Object)job);
                job.setHandlerParam(param.getParam());
                this.eruptJobService.triggerJob(job);
            }
            return null;
        }
        catch (Exception e) {
            throw new EruptWebApiRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public EruptJobExecDialog eruptFormValue(List<EruptJob> data, EruptJobExecDialog eruptJobExecDialog, String[] param) {
        eruptJobExecDialog.setParam(data.get(0).getHandlerParam());
        return eruptJobExecDialog;
    }

    public void addBehavior(EruptJob eruptJob) {
        eruptJob.setCode(Erupts.generateCode());
    }
}

