/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.job.model.data_proxy;

import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;
import javax.mail.internet.MimeMessage;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Service;
import xyz.erupt.annotation.fun.DataProxy;
import xyz.erupt.core.context.MetaContext;
import xyz.erupt.core.util.Erupts;
import xyz.erupt.job.model.EruptMail;

@Service
public class EruptMailDataProxy
implements DataProxy<EruptMail> {
    @Transient
    @Autowired(required=false)
    private JavaMailSenderImpl javaMailSender;

    public void beforeAdd(EruptMail eruptMail) {
        Erupts.requireNonNull((Object)this.javaMailSender, (String)"Sending mailbox not configured");
        MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true, StandardCharsets.UTF_8.name());
        eruptMail.setCreateBy(MetaContext.getUser().getName());
        eruptMail.setCreateTime(new Date());
        helper.setSubject(eruptMail.getSubject());
        helper.setTo(eruptMail.getRecipient());
        helper.setFrom(Objects.requireNonNull(this.javaMailSender.getUsername()));
        if (StringUtils.isNotBlank((CharSequence)eruptMail.getCc())) {
            helper.setCc(eruptMail.getCc().split("\\|"));
        }
        helper.setText(eruptMail.getContent(), true);
        try {
            this.javaMailSender.send(mimeMessage);
            eruptMail.setStatus(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            eruptMail.setStatus(false);
            Optional.ofNullable(e.toString()).ifPresent(it -> eruptMail.setErrorInfo(it.substring(0, 5000)));
        }
    }
}

