/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.job.model;

import java.text.ParseException;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.quartz.SchedulerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import xyz.erupt.annotation.Erupt;
import xyz.erupt.annotation.EruptField;
import xyz.erupt.annotation.fun.DataProxy;
import xyz.erupt.annotation.fun.OperationHandler;
import xyz.erupt.annotation.sub_erupt.RowOperation;
import xyz.erupt.annotation.sub_field.Edit;
import xyz.erupt.annotation.sub_field.EditType;
import xyz.erupt.annotation.sub_field.View;
import xyz.erupt.annotation.sub_field.sub_edit.BoolType;
import xyz.erupt.annotation.sub_field.sub_edit.Search;
import xyz.erupt.annotation.sub_field.sub_edit.TagsType;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.job.service.EruptJobService;
import xyz.erupt.upms.model.base.HyperModel;

@Erupt(name="\u4efb\u52a1\u7ef4\u62a4", dataProxy={EruptJob.class}, rowOperation={@RowOperation(code="action", icon="fa fa-play", title="\u6267\u884c\u4e00\u6b21\u4efb\u52a1", operationHandler=EruptJob.class)})
@Entity
@Table(name="e_job", uniqueConstraints={@UniqueConstraint(columnNames={"code"})})
@Component
public class EruptJob
extends HyperModel
implements DataProxy<EruptJob>,
OperationHandler<EruptJob, Void> {
    @EruptField(views={@View(title="\u4efb\u52a1\u7f16\u7801")}, edit=@Edit(title="\u4efb\u52a1\u7f16\u7801", notNull=true, search=@Search))
    private String code;
    @EruptField(views={@View(title="\u4efb\u52a1\u540d\u79f0")}, edit=@Edit(title="\u4efb\u52a1\u540d\u79f0", notNull=true, search=@Search(vague=true)))
    private String name;
    @EruptField(views={@View(title="Cron\u8868\u8fbe\u5f0f")}, edit=@Edit(title="Cron\u8868\u8fbe\u5f0f", notNull=true))
    private String cron;
    @EruptField(views={@View(title="JOB\u5904\u7406\u7c7b")}, edit=@Edit(title="JOB\u5904\u7406\u7c7b", desc="\u9700\u5b9e\u73b0EruptJobHandler\u63a5\u53e3", notNull=true, search=@Search(vague=true)))
    private String handler;
    @EruptField(views={@View(title="\u4efb\u52a1\u72b6\u6001")}, edit=@Edit(title="\u4efb\u52a1\u72b6\u6001", boolType=@BoolType(trueText="\u542f\u7528", falseText="\u7981\u7528"), notNull=true, search=@Search))
    private Boolean status;
    @Lob
    @EruptField(views={@View(title="\u5931\u8d25\u901a\u77e5\u90ae\u7bb1")}, edit=@Edit(title="\u5931\u8d25\u901a\u77e5\u90ae\u7bb1", desc="\u4f7f\u7528\u6b64\u529f\u80fd\u9700\u914d\u7f6e\u53d1\u4fe1\u90ae\u7bb1\u4fe1\u606f", type=EditType.TAGS, tagsType=@TagsType))
    private String notifyEmails;
    @Lob
    @EruptField(views={@View(title="\u4efb\u52a1\u53c2\u6570")}, edit=@Edit(title="\u4efb\u52a1\u53c2\u6570", type=EditType.TEXTAREA))
    private String handlerParam;
    @Lob
    @EruptField(views={@View(title="\u63cf\u8ff0")}, edit=@Edit(title="\u63cf\u8ff0"))
    private String remark;
    @Transient
    @Autowired
    private EruptJobService eruptJobService;

    public void beforeAdd(EruptJob eruptJob) {
        try {
            this.eruptJobService.modifyJob(eruptJob);
        }
        catch (ParseException | SchedulerException e) {
            throw new EruptWebApiRuntimeException(e.getMessage());
        }
    }

    public void beforeUpdate(EruptJob eruptJob) {
        this.beforeAdd(eruptJob);
    }

    public void beforeDelete(EruptJob eruptJob) {
        try {
            this.eruptJobService.deleteJob(eruptJob);
        }
        catch (SchedulerException e) {
            throw new EruptWebApiRuntimeException(e.getMessage());
        }
    }

    public void exec(List<EruptJob> eruptJob, Void param, String[] operationParam) {
        try {
            this.eruptJobService.triggerJob(eruptJob.get(0));
        }
        catch (Exception e) {
            throw new EruptWebApiRuntimeException(e.getMessage());
        }
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getCron() {
        return this.cron;
    }

    public String getHandler() {
        return this.handler;
    }

    public Boolean getStatus() {
        return this.status;
    }

    public String getNotifyEmails() {
        return this.notifyEmails;
    }

    public String getHandlerParam() {
        return this.handlerParam;
    }

    public String getRemark() {
        return this.remark;
    }

    public EruptJobService getEruptJobService() {
        return this.eruptJobService;
    }
}

