/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.job.service;

import java.util.List;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import xyz.erupt.core.util.ProjectUtil;
import xyz.erupt.job.model.EruptJob;
import xyz.erupt.job.model.EruptJobLog;
import xyz.erupt.job.service.EruptJobService;
import xyz.erupt.jpa.dao.EruptDao;
import xyz.erupt.upms.constant.MenuTypeEnum;
import xyz.erupt.upms.model.EruptMenu;

@Service
@Order
public class JobDataLoadService
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(JobDataLoadService.class);
    @Autowired
    private EruptDao eruptDao;
    @Autowired
    private EruptJobService eruptJobService;
    @Value(value="${erupt.job.enable:true}")
    private Boolean openJob;

    @Transactional
    public void run(String ... args) throws Exception {
        if (this.openJob.booleanValue()) {
            List list = this.eruptDao.queryEntityList(EruptJob.class, "status = true", null);
            for (EruptJob job : list) {
                this.eruptJobService.modifyJob(job);
            }
            log.info("Erupt job initialization complete");
        } else {
            log.info("Erupt job disable");
        }
        new ProjectUtil().projectStartLoaded("job", first -> {
            if (first.booleanValue()) {
                String job = "$job";
                String code = "code";
                EruptMenu eruptMenu = (EruptMenu)this.eruptDao.persistIfNotExist(EruptMenu.class, (Object)new EruptMenu(job, "\u4efb\u52a1\u7ba1\u7406", null, null, Integer.valueOf(1), Integer.valueOf(30), "fa fa-cubes", null), code, job);
                this.eruptDao.persistIfNotExist(EruptMenu.class, (Object)new EruptMenu(EruptJob.class.getSimpleName(), "\u4efb\u52a1\u7ef4\u62a4", MenuTypeEnum.TABLE.getCode(), EruptJob.class.getSimpleName(), Integer.valueOf("1"), Integer.valueOf(0), "fa fa-tasks", eruptMenu), code, EruptJob.class.getSimpleName());
                this.eruptDao.persistIfNotExist(EruptMenu.class, (Object)new EruptMenu(EruptJobLog.class.getSimpleName(), "\u4efb\u52a1\u65e5\u5fd7", MenuTypeEnum.TABLE.getCode(), EruptJobLog.class.getSimpleName(), Integer.valueOf("1"), Integer.valueOf(10), "fa fa-file-text", eruptMenu), code, EruptJobLog.class.getSimpleName());
            }
        });
    }
}

