/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.job.service;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Service;
import xyz.erupt.core.service.EruptApplication;
import xyz.erupt.core.toolkit.TimeRecorder;
import xyz.erupt.core.util.EruptSpringUtil;
import xyz.erupt.core.util.ProjectUtil;
import xyz.erupt.job.config.EruptJobProp;
import xyz.erupt.job.handler.EruptJobHandler;
import xyz.erupt.job.model.EruptJob;
import xyz.erupt.job.model.EruptJobLog;
import xyz.erupt.job.model.EruptMail;
import xyz.erupt.job.service.EruptJobService;
import xyz.erupt.jpa.dao.EruptDao;
import xyz.erupt.upms.enums.MenuTypeEnum;
import xyz.erupt.upms.model.EruptMenu;

@Service
@Order
public class JobDataLoadService
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(JobDataLoadService.class);
    @Resource
    private EruptDao eruptDao;
    @Resource
    private EruptJobService eruptJobService;
    @Resource
    private EruptJobProp eruptJobProp;
    private static final List<String> loadedJobHandler = new ArrayList<String>();

    public static List<String> getLoadedJobHandler() {
        return loadedJobHandler;
    }

    @Transactional
    public void run(String ... args) throws Exception {
        TimeRecorder timeRecorder = new TimeRecorder();
        EruptSpringUtil.scannerPackage((String[])EruptApplication.getScanPackage(), (TypeFilter[])new TypeFilter[]{new AssignableTypeFilter(EruptJobHandler.class)}, clazz -> loadedJobHandler.add(clazz.getName()));
        if (this.eruptJobProp.isEnable()) {
            List list = this.eruptDao.queryEntityList(EruptJob.class, "status = true", null);
            for (EruptJob job : list) {
                this.eruptJobService.modifyJob(job);
            }
            log.info("Erupt job initialization completed in {} ms", (Object)timeRecorder.recorder());
        } else {
            log.info("Erupt job disable");
        }
        new ProjectUtil().projectStartLoaded("job", first -> {
            if (first.booleanValue()) {
                String job = "$job";
                String code = "code";
                EruptMenu eruptMenu = (EruptMenu)this.eruptDao.persistIfNotExist(EruptMenu.class, (Object)new EruptMenu(job, "\u4efb\u52a1\u7ba1\u7406", null, null, Integer.valueOf(1), Integer.valueOf(30), "fa fa-cubes", null), code, job);
                this.eruptDao.persistIfNotExist(EruptMenu.class, (Object)new EruptMenu(EruptJob.class.getSimpleName(), "\u4efb\u52a1\u7ef4\u62a4", MenuTypeEnum.TABLE.getCode(), EruptJob.class.getSimpleName(), Integer.valueOf("1"), Integer.valueOf(0), "fa fa-tasks", eruptMenu), code, EruptJob.class.getSimpleName());
                this.eruptDao.persistIfNotExist(EruptMenu.class, (Object)new EruptMenu(EruptJobLog.class.getSimpleName(), "\u4efb\u52a1\u65e5\u5fd7", MenuTypeEnum.TABLE.getCode(), EruptJobLog.class.getSimpleName(), Integer.valueOf("1"), Integer.valueOf(10), "fa fa-file-text", eruptMenu), code, EruptJobLog.class.getSimpleName());
                this.eruptDao.persistIfNotExist(EruptMail.class, (Object)new EruptMenu(EruptMail.class.getSimpleName(), "\u53d1\u9001\u90ae\u4ef6", MenuTypeEnum.TABLE.getCode(), EruptMail.class.getSimpleName(), Integer.valueOf("1"), Integer.valueOf(20), "fa fa-envelope-o", eruptMenu), code, EruptMail.class.getSimpleName());
            }
        });
    }
}

