/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.job.service;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.transaction.Transactional;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.Trigger;
import org.quartz.impl.JobDetailImpl;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.simpl.SimpleThreadPool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.stereotype.Service;
import xyz.erupt.job.model.EruptJob;
import xyz.erupt.job.model.EruptJobLog;
import xyz.erupt.job.service.EruptJobAction;
import xyz.erupt.jpa.dao.EruptDao;

@Service
public class EruptJobService {
    private static final String PROP_THREAD_COUNT = "org.quartz.threadPool.threadCount";
    private static final int DEFAULT_THREAD_COUNT = 1;
    @Autowired
    private EruptDao eruptDao;
    @Autowired
    private JavaMailSenderImpl javaMailSender;
    public static final String MAIL_SENDER_KEY = "mailSensor";
    private final Map<String, StdSchedulerFactory> schedulerFactoryMap = new HashMap<String, StdSchedulerFactory>();

    public void triggerJob(EruptJob eruptJob) {
        new EruptJobAction().trigger(eruptJob, this.javaMailSender);
    }

    public void modifyJob(EruptJob eruptJob) throws SchedulerException, ParseException {
        String code = eruptJob.getCode();
        if (this.schedulerFactoryMap.containsKey(code)) {
            this.deleteJob(eruptJob);
        }
        if (eruptJob.getStatus().booleanValue()) {
            StdSchedulerFactory ssf = new StdSchedulerFactory();
            ssf.initialize(this.getSchedulerProp(code));
            Scheduler scheduler = ssf.getScheduler();
            JobDetailImpl job = new JobDetailImpl();
            JobDataMap jobDataMap = new JobDataMap();
            jobDataMap.put(code, (Object)eruptJob);
            jobDataMap.put(MAIL_SENDER_KEY, (Object)this.javaMailSender);
            job.setJobDataMap(jobDataMap);
            job.setName(code);
            job.setJobClass(EruptJobAction.class);
            CronTriggerImpl trigger = new CronTriggerImpl();
            trigger.setName(code);
            trigger.setCronExpression(eruptJob.getCron());
            scheduler.scheduleJob((JobDetail)job, (Trigger)trigger);
            scheduler.start();
            this.schedulerFactoryMap.put(code, ssf);
        }
    }

    public void deleteJob(EruptJob eruptJob) throws SchedulerException {
        SchedulerFactory sf = (SchedulerFactory)this.schedulerFactoryMap.get(eruptJob.getCode());
        if (null != sf) {
            Scheduler scheduler = sf.getScheduler();
            scheduler.deleteJob(new JobKey(eruptJob.getCode()));
            if (!scheduler.isShutdown()) {
                scheduler.shutdown();
            }
            this.schedulerFactoryMap.remove(eruptJob.getCode());
        }
    }

    private Properties getSchedulerProp(String schedulerName) {
        Properties props = new Properties();
        props.setProperty("org.quartz.scheduler.makeSchedulerThreadDaemon", "true");
        props.setProperty("org.quartz.scheduler.interruptJobsOnShutdownWithWait", "true");
        props.setProperty("org.quartz.scheduler.interruptJobsOnShutdown", "true");
        props.setProperty("org.quartz.scheduler.instanceId", "AUTO");
        props.setProperty("org.quartz.scheduler.instanceName", schedulerName);
        props.setProperty("org.quartz.threadPool.class", SimpleThreadPool.class.getName());
        props.setProperty(PROP_THREAD_COUNT, Integer.toString(1));
        return props;
    }

    @Transactional
    public void saveJobLog(EruptJobLog eruptJobLog) {
        this.eruptDao.persist((Object)eruptJobLog);
    }
}

