/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.job.model;

import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Objects;
import javax.mail.internet.MimeMessage;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.stereotype.Component;
import xyz.erupt.annotation.Erupt;
import xyz.erupt.annotation.EruptField;
import xyz.erupt.annotation.EruptI18n;
import xyz.erupt.annotation.fun.DataProxy;
import xyz.erupt.annotation.sub_erupt.Power;
import xyz.erupt.annotation.sub_field.Edit;
import xyz.erupt.annotation.sub_field.EditType;
import xyz.erupt.annotation.sub_field.View;
import xyz.erupt.annotation.sub_field.sub_edit.InputType;
import xyz.erupt.annotation.sub_field.sub_edit.Search;
import xyz.erupt.core.util.Erupts;
import xyz.erupt.upms.model.base.HyperModel;

@EruptI18n
@Erupt(name="\u53d1\u9001\u90ae\u4ef6", dataProxy={EruptMail.class}, power=@Power(edit=false), orderBy="id desc")
@Entity
@Table(name="e_job_mail")
@Component
public class EruptMail
extends HyperModel
implements DataProxy<EruptMail> {
    @EruptField(views={@View(title="\u63a5\u6536\u4eba")}, edit=@Edit(title="\u63a5\u6536\u4eba", notNull=true, search=@Search, inputType=@InputType(fullSpan=true, regex="^([a-z0-9A-Z]+[-|_|\\.]?)+[a-z0-9A-Z]@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-zA-Z]{2,}$")))
    private String recipient;
    @EruptField(views={@View(title="\u6284\u9001\u4eba", template="value&&value.replace(/\\|/g,'<span class=\"text-red\"> | </span>')")}, edit=@Edit(title="\u6284\u9001\u4eba", type=EditType.TAGS))
    private String cc;
    @EruptField(views={@View(title="\u4e3b\u9898")}, edit=@Edit(title="\u4e3b\u9898", notNull=true, search=@Search, inputType=@InputType(fullSpan=true)))
    private String subject;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    @EruptField(views={@View(title="\u5185\u5bb9")}, edit=@Edit(title="\u5185\u5bb9", notNull=true, type=EditType.HTML_EDITOR))
    private String content;
    @EruptField(views={@View(title="\u53d1\u9001\u65f6\u95f4")})
    private Date createTime;
    @Transient
    @Autowired(required=false)
    private JavaMailSenderImpl javaMailSender;

    public void beforeAdd(EruptMail eruptMail) {
        Erupts.requireNonNull((Object)this.javaMailSender, (String)"Sending mailbox not configured");
        MimeMessage mimeMessage = this.javaMailSender.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(mimeMessage, true, StandardCharsets.UTF_8.name());
        helper.setSubject(eruptMail.getSubject());
        helper.setTo(eruptMail.getRecipient());
        helper.setFrom(Objects.requireNonNull(this.javaMailSender.getUsername()));
        if (StringUtils.isNotBlank((CharSequence)eruptMail.getCc())) {
            helper.setCc(eruptMail.getCc().split("\\|"));
        }
        helper.setText(eruptMail.getContent(), true);
        this.javaMailSender.send(mimeMessage);
    }

    public String getRecipient() {
        return this.recipient;
    }

    public String getCc() {
        return this.cc;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getContent() {
        return this.content;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public JavaMailSenderImpl getJavaMailSender() {
        return this.javaMailSender;
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient;
    }

    public void setCc(String cc) {
        this.cc = cc;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setJavaMailSender(JavaMailSenderImpl javaMailSender) {
        this.javaMailSender = javaMailSender;
    }
}

