/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.monitor.vo;

import java.lang.management.ManagementFactory;
import java.text.DecimalFormat;
import java.util.Properties;
import xyz.erupt.monitor.util.SystemUtil;

public class Jvm {
    private String name;
    private String vendor;
    private String version;
    private String inputArgs;
    private String pid;
    private String home;
    private String path;
    private int threadCount;
    private String total;
    private String used;
    private String free;
    private String usage;

    Jvm() {
        Properties props = System.getProperties();
        long total = Runtime.getRuntime().totalMemory();
        long free = Runtime.getRuntime().freeMemory();
        this.setTotal(SystemUtil.formatByte(total));
        this.setUsed(SystemUtil.formatByte(total - free));
        this.setFree(SystemUtil.formatByte(free));
        this.setUsage(new DecimalFormat("#.##%").format((double)(total - free) * 1.0 / (double)total));
        this.setVersion(props.getProperty("java.version"));
        this.setHome(props.getProperty("java.home"));
        this.setInputArgs(ManagementFactory.getRuntimeMXBean().getInputArguments().toString());
        this.setPid(ManagementFactory.getRuntimeMXBean().getName().split("@")[0]);
        this.setName(props.getProperty("java.vm.name"));
        this.setVendor(props.getProperty("java.vendor"));
        this.setPath(props.getProperty("user.dir"));
        this.setThreadCount(ManagementFactory.getThreadMXBean().getThreadCount());
    }

    public String getName() {
        return this.name;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getVersion() {
        return this.version;
    }

    public String getInputArgs() {
        return this.inputArgs;
    }

    public String getPid() {
        return this.pid;
    }

    public String getHome() {
        return this.home;
    }

    public String getPath() {
        return this.path;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public String getTotal() {
        return this.total;
    }

    public String getUsed() {
        return this.used;
    }

    public String getFree() {
        return this.free;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setInputArgs(String inputArgs) {
        this.inputArgs = inputArgs;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public void setTotal(String total) {
        this.total = total;
    }

    public void setUsed(String used) {
        this.used = used;
    }

    public void setFree(String free) {
        this.free = free;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }
}

