/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.monitor.vo;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Date;
import java.util.Enumeration;

public class Sys {
    private String name;
    private String arch;
    private String hostName;
    private Date date;

    Sys() {
        InetAddress addr = InetAddress.getLocalHost();
        this.setHostName(addr.getHostName());
        OperatingSystemMXBean osb = ManagementFactory.getOperatingSystemMXBean();
        this.setName(osb.getName() + " " + osb.getVersion());
        this.setArch(osb.getArch());
        this.setDate(new Date());
    }

    public static String getServerIp() {
        Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
        while (netInterfaces.hasMoreElements()) {
            InetAddress addr = netInterfaces.nextElement().getInetAddresses().nextElement();
            if (!(addr instanceof Inet4Address) || !addr.isSiteLocalAddress() || addr.isLoopbackAddress()) continue;
            return addr.getHostAddress();
        }
        return InetAddress.getLocalHost().getHostAddress();
    }

    public String getName() {
        return this.name;
    }

    public String getArch() {
        return this.arch;
    }

    public String getHostName() {
        return this.hostName;
    }

    public Date getDate() {
        return this.date;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setArch(String arch) {
        this.arch = arch;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setDate(Date date) {
        this.date = date;
    }
}

