/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.monitor.vo;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import oshi.SystemInfo;
import oshi.software.os.OperatingSystem;
import xyz.erupt.core.util.EruptSpringUtil;
import xyz.erupt.monitor.vo.Cpu;
import xyz.erupt.monitor.vo.Jvm;
import xyz.erupt.monitor.vo.Mem;
import xyz.erupt.monitor.vo.Sys;
import xyz.erupt.monitor.vo.SysFile;

public class Server {
    private Cpu cpu;
    private Mem mem;
    private Jvm jvm;
    private Sys sys;
    private List<SysFile> sysFiles;
    private Date startupDate;
    private String runDay;

    public Server() {
        SystemInfo si = new SystemInfo();
        OperatingSystem os = si.getOperatingSystem();
        this.setCpu(new Cpu(si));
        this.setMem(new Mem(si));
        this.setJvm(new Jvm());
        this.setSys(new Sys());
        long startupDate = EruptSpringUtil.getApplicationContext().getStartupDate();
        this.setStartupDate(new Date(startupDate));
        this.setRunDay(this.zhDateDiff(this.getStartupDate()));
        this.sysFiles = os.getFileSystem().getFileStores().stream().map(SysFile::new).collect(Collectors.toList());
    }

    private String zhDateDiff(Date date) {
        long l = System.currentTimeMillis() - date.getTime();
        long day = l / 86400000L;
        long hour = l / 3600000L - day * 24L;
        long min = l / 60000L - day * 24L * 60L - hour * 60L;
        return day + "\u5929" + hour + "\u5c0f\u65f6" + min + "\u5206";
    }

    public Cpu getCpu() {
        return this.cpu;
    }

    public Mem getMem() {
        return this.mem;
    }

    public Jvm getJvm() {
        return this.jvm;
    }

    public Sys getSys() {
        return this.sys;
    }

    public List<SysFile> getSysFiles() {
        return this.sysFiles;
    }

    public Date getStartupDate() {
        return this.startupDate;
    }

    public String getRunDay() {
        return this.runDay;
    }

    public void setCpu(Cpu cpu) {
        this.cpu = cpu;
    }

    public void setMem(Mem mem) {
        this.mem = mem;
    }

    public void setJvm(Jvm jvm) {
        this.jvm = jvm;
    }

    public void setSys(Sys sys) {
        this.sys = sys;
    }

    public void setSysFiles(List<SysFile> sysFiles) {
        this.sysFiles = sysFiles;
    }

    public void setStartupDate(Date startupDate) {
        this.startupDate = startupDate;
    }

    public void setRunDay(String runDay) {
        this.runDay = runDay;
    }
}

