/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.tpl.controller;

import com.google.gson.JsonObject;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import xyz.erupt.annotation.expr.ExprBool;
import xyz.erupt.annotation.sub_erupt.RowOperation;
import xyz.erupt.annotation.sub_erupt.Tpl;
import xyz.erupt.core.annotation.EruptRouter;
import xyz.erupt.core.exception.EruptNoLegalPowerException;
import xyz.erupt.core.invoke.DataProcessorManager;
import xyz.erupt.core.invoke.ExprInvoke;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.core.util.EruptSpringUtil;
import xyz.erupt.core.util.EruptUtil;
import xyz.erupt.core.util.Erupts;
import xyz.erupt.core.view.EruptFieldModel;
import xyz.erupt.core.view.EruptModel;
import xyz.erupt.tpl.annotation.EruptTpl;
import xyz.erupt.tpl.annotation.TplAction;
import xyz.erupt.tpl.service.EruptTplService;

@RestController
@RequestMapping(value={"/erupt-api/tpl"})
public class EruptTplController
implements EruptRouter.VerifyHandler {
    static final String TPL = "/tpl";
    private static final String HTML_MIME_TYPE = "text/html;charset=utf-8";
    @Resource
    private EruptTplService eruptTplService;

    @GetMapping(value={"/**"}, produces={"text/html;charset=utf-8"})
    @EruptRouter(authIndex=1, verifyType=EruptRouter.VerifyType.MENU, verifyHandler=EruptTplController.class, verifyMethod=EruptRouter.VerifyMethod.PARAM)
    public void eruptTplPage(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        String path = request.getRequestURI().split("/erupt-api/tpl/")[1];
        Method method = this.eruptTplService.getAction(path);
        if (null == method) {
            this.eruptTplService.tplRender(Tpl.Engine.Native, "/tpl/" + path, null, response.getWriter());
            return;
        }
        Object obj = EruptSpringUtil.getBean(method.getDeclaringClass());
        EruptTpl eruptTpl = obj.getClass().getAnnotation(EruptTpl.class);
        TplAction tplAction = method.getAnnotation(TplAction.class);
        path = "/tpl/" + path;
        if (StringUtils.isNotBlank((CharSequence)tplAction.path())) {
            path = tplAction.path();
        }
        this.eruptTplService.tplRender(eruptTpl.engine(), path, (Map)method.invoke(obj, new Object[0]), response.getWriter());
    }

    public String convertAuthStr(EruptRouter eruptRouter, HttpServletRequest request, String authStr) {
        return request.getRequestURI().split("/erupt-api/tpl/")[1];
    }

    @GetMapping(value={"/html-field/{erupt}/{field}"}, produces={"text/html;charset=utf-8"})
    @EruptRouter(authIndex=2, verifyType=EruptRouter.VerifyType.MENU, verifyMethod=EruptRouter.VerifyMethod.PARAM)
    public void eruptFieldHtml(@PathVariable(value="erupt") String eruptName, @PathVariable(value="field") String field, HttpServletResponse response) {
        EruptModel eruptModel = EruptCoreService.getErupt((String)eruptName);
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        Tpl tpl = ((EruptFieldModel)eruptModel.getEruptFieldMap().get(field)).getEruptField().edit().tplType();
        this.eruptTplService.tplRender(tpl, null, response);
    }

    @GetMapping(value={"/operation_tpl/{erupt}/{code}"}, produces={"text/html;charset=utf-8"})
    @EruptRouter(authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT, verifyMethod=EruptRouter.VerifyMethod.PARAM)
    public void operationTpl(@PathVariable(value="erupt") String eruptName, @PathVariable(value="code") String code, @RequestParam(value="ids", required=false) String[] ids, HttpServletResponse response) {
        EruptModel eruptModel = EruptCoreService.getErupt((String)eruptName);
        RowOperation operation = Arrays.stream(eruptModel.getErupt().rowOperation()).filter(it -> it.code().equals(code)).findFirst().orElseThrow(EruptNoLegalPowerException::new);
        Erupts.powerLegal((Boolean)ExprInvoke.getExpr((ExprBool)operation.show()));
        if (operation.tpl().engine() == Tpl.Engine.Native || operation.mode() == RowOperation.Mode.BUTTON) {
            this.eruptTplService.tplRender(operation.tpl(), null, response);
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rows", Stream.of(ids).map(id -> DataProcessorManager.getEruptDataProcessor((Class)eruptModel.getClazz()).findDataById(eruptModel, EruptUtil.toEruptId((EruptModel)eruptModel, (String)id))).collect(Collectors.toList()));
        this.eruptTplService.tplRender(operation.tpl(), map, response);
    }

    @GetMapping(value={"/view_tpl/{erupt}/{field}"}, produces={"text/html;charset=utf-8"})
    @EruptRouter(authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT, verifyMethod=EruptRouter.VerifyMethod.PARAM)
    public void viewTpl(@PathVariable(value="erupt") String eruptName, @PathVariable(value="field") String field, @RequestParam JsonObject row, HttpServletResponse response) {
        EruptModel eruptModel = EruptCoreService.getErupt((String)eruptName);
        Tpl tpl = ((EruptFieldModel)eruptModel.getEruptFieldMap().get(field)).getEruptField().views()[0].tpl();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("row", row);
        this.eruptTplService.tplRender(tpl, map, response);
    }
}

