/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.tpl.controller;

import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import xyz.erupt.annotation.expr.ExprBool;
import xyz.erupt.annotation.sub_erupt.RowOperation;
import xyz.erupt.annotation.sub_erupt.Tpl;
import xyz.erupt.core.annotation.EruptRouter;
import xyz.erupt.core.exception.EruptNoLegalPowerException;
import xyz.erupt.core.invoke.DataProcessorManager;
import xyz.erupt.core.invoke.ExprInvoke;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.core.util.EruptSpringUtil;
import xyz.erupt.core.util.EruptUtil;
import xyz.erupt.core.view.EruptFieldModel;
import xyz.erupt.core.view.EruptModel;
import xyz.erupt.tpl.annotation.EruptTpl;
import xyz.erupt.tpl.annotation.TplAction;
import xyz.erupt.tpl.service.EruptTplService;

@RestController
@RequestMapping(value={"/erupt-api/tpl"})
public class EruptTplController {
    public static final String TPL = "/tpl";
    @Resource
    private EruptTplService eruptTplService;

    @GetMapping(value={"/{name}"}, produces={"text/html;charset=utf-8"})
    @EruptRouter(authIndex=1, verifyType=EruptRouter.VerifyType.MENU, verifyMethod=EruptRouter.VerifyMethod.PARAM)
    public void eruptTplPage(@PathVariable(value="name") String fileName, HttpServletResponse response) throws Exception {
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        Method method = this.eruptTplService.getAction(fileName);
        if (null != method) {
            Object obj = EruptSpringUtil.getBean(method.getDeclaringClass());
            EruptTpl eruptTpl = obj.getClass().getAnnotation(EruptTpl.class);
            TplAction tplAction = method.getAnnotation(TplAction.class);
            String path = "/tpl/" + fileName;
            if (StringUtils.isNotBlank((CharSequence)tplAction.path())) {
                path = tplAction.path();
            }
            this.eruptTplService.tplRender(eruptTpl.engine(), path, (Map)method.invoke(obj, new Object[0]), response.getWriter());
        } else {
            this.eruptTplService.tplRender(Tpl.Engine.Native, "/tpl/" + fileName, null, response.getWriter());
        }
    }

    @GetMapping(value={"/html-field/{erupt}/{field}"}, produces={"text/html;charset=UTF-8"})
    @EruptRouter(authIndex=2, verifyType=EruptRouter.VerifyType.MENU, verifyMethod=EruptRouter.VerifyMethod.PARAM)
    public void getEruptFieldHtml(@PathVariable(value="erupt") String eruptName, @PathVariable(value="field") String field, HttpServletResponse response) {
        EruptModel eruptModel = EruptCoreService.getErupt((String)eruptName);
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        Tpl tpl = ((EruptFieldModel)eruptModel.getEruptFieldMap().get(field)).getEruptField().edit().tplType();
        this.eruptTplService.tplRender(tpl, null, response);
    }

    @GetMapping(value={"/operation_tpl/{erupt}/{code}"}, produces={"text/html;charset=utf-8"})
    @EruptRouter(authIndex=2, verifyType=EruptRouter.VerifyType.ERUPT, verifyMethod=EruptRouter.VerifyMethod.PARAM)
    public void getOperationTpl(@PathVariable(value="erupt") String eruptName, @PathVariable(value="code") String code, @RequestParam(value="ids", required=false) String[] ids, HttpServletResponse response) {
        EruptModel eruptModel = EruptCoreService.getErupt((String)eruptName);
        for (RowOperation operation : eruptModel.getErupt().rowOperation()) {
            if (!operation.code().equals(code)) continue;
            if (!ExprInvoke.getExpr((ExprBool)operation.show()).booleanValue()) {
                throw new EruptNoLegalPowerException();
            }
            if (operation.tpl().engine() == Tpl.Engine.Native || operation.mode() == RowOperation.Mode.BUTTON) {
                this.eruptTplService.tplRender(operation.tpl(), null, response);
                continue;
            }
            ArrayList<Object> list = new ArrayList<Object>();
            for (String id : ids) {
                Object obj = DataProcessorManager.getEruptDataProcessor((Class)eruptModel.getClazz()).findDataById(eruptModel, EruptUtil.toEruptId((EruptModel)eruptModel, (String)id));
                list.add(obj);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("rows", list);
            this.eruptTplService.tplRender(operation.tpl(), map, response);
        }
    }
}

