/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.controller;

import com.google.gson.reflect.TypeToken;
import com.wf.captcha.SpecCaptcha;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import xyz.erupt.core.annotation.EruptRouter;
import xyz.erupt.core.prop.EruptAppProp;
import xyz.erupt.core.util.Erupts;
import xyz.erupt.core.view.EruptApiModel;
import xyz.erupt.upms.base.LoginModel;
import xyz.erupt.upms.fun.LoginProxy;
import xyz.erupt.upms.model.EruptUser;
import xyz.erupt.upms.service.EruptContextService;
import xyz.erupt.upms.service.EruptSessionService;
import xyz.erupt.upms.service.EruptUserService;
import xyz.erupt.upms.util.IpUtil;
import xyz.erupt.upms.vo.AdminUserinfo;
import xyz.erupt.upms.vo.EruptMenuVo;

@RestController
@RequestMapping(value={"/erupt-api"})
public class EruptUserController {
    @Resource
    private EruptUserService eruptUserService;
    @Resource
    private EruptSessionService sessionService;
    @Resource
    private EruptAppProp eruptAppProp;
    @Resource
    private EruptContextService eruptContextService;

    @PostMapping(value={"/login"})
    public LoginModel login(@RequestParam(value="account") String account, @RequestParam(value="pwd") String pwd, @RequestParam(name="verifyCode", required=false) String verifyCode) {
        EruptUser eruptUser;
        LoginModel loginModel;
        if (!this.eruptUserService.checkVerifyCode(verifyCode)) {
            LoginModel loginModel2 = new LoginModel();
            loginModel2.setUseVerifyCode(true);
            loginModel2.setReason("\u9a8c\u8bc1\u7801\u9519\u8bef");
            loginModel2.setPass(false);
            return loginModel2;
        }
        LoginProxy loginProxy = EruptUserService.findEruptLogin();
        if (null == loginProxy) {
            loginModel = this.eruptUserService.login(account, pwd);
        } else {
            loginModel = new LoginModel();
            try {
                eruptUser = loginProxy.login(account, pwd);
                loginModel.setEruptUser(eruptUser);
                loginModel.setPass(true);
            }
            catch (Exception e) {
                if (0 == this.eruptAppProp.getVerifyCodeCount()) {
                    loginModel.setUseVerifyCode(true);
                }
                loginModel.setReason(e.getMessage());
                loginModel.setPass(false);
            }
        }
        if (loginModel.isPass()) {
            eruptUser = loginModel.getEruptUser();
            loginModel.setToken(Erupts.generateCode((int)16));
            loginModel.setExpire(this.eruptUserService.getExpireTime());
            loginModel.setResetPwd(null == eruptUser.getResetPwdTime());
            this.eruptUserService.putUserInfo(eruptUser, loginModel.getToken());
            Optional.ofNullable(loginProxy).ifPresent(it -> it.loginSuccess(eruptUser, loginModel.getToken()));
            this.eruptUserService.cacheUserInfo(eruptUser, loginModel.getToken());
            this.eruptUserService.saveLoginLog(eruptUser, loginModel.getToken());
        }
        return loginModel;
    }

    @GetMapping(value={"/userinfo"})
    @EruptRouter(verifyType=EruptRouter.VerifyType.LOGIN)
    public AdminUserinfo userinfo() {
        AdminUserinfo adminUserinfo = this.eruptUserService.getSimpleUserInfo();
        adminUserinfo.setId(null);
        return adminUserinfo;
    }

    @GetMapping(value={"/menu"})
    @EruptRouter(verifyType=EruptRouter.VerifyType.LOGIN)
    public List<EruptMenuVo> getMenu() {
        return (List)this.sessionService.get("eruptAuth:menu-view:" + this.eruptContextService.getCurrentToken(), new TypeToken<List<EruptMenuVo>>(){}.getType());
    }

    @PostMapping(value={"/logout"})
    @EruptRouter(verifyType=EruptRouter.VerifyType.LOGIN)
    public EruptApiModel logout() {
        String token = this.eruptContextService.getCurrentToken();
        LoginProxy loginProxy = EruptUserService.findEruptLogin();
        Optional.ofNullable(loginProxy).ifPresent(it -> it.logout(token));
        this.sessionService.remove("eruptAuth:menu-value-map:" + token);
        this.sessionService.remove("eruptAuth:menu-code-map:" + token);
        this.sessionService.remove("eruptAuth:menu-view:" + token);
        this.sessionService.remove("eruptAuth:token:" + token);
        return EruptApiModel.successApi();
    }

    @PostMapping(value={"/change-pwd"})
    @EruptRouter(verifyType=EruptRouter.VerifyType.LOGIN)
    public EruptApiModel changePwd(@RequestParam(value="account") String account, @RequestParam(value="pwd") String pwd, @RequestParam(value="newPwd") String newPwd, @RequestParam(value="newPwd2") String newPwd2) {
        return this.eruptUserService.changePwd(account, pwd, newPwd, newPwd2);
    }

    @GetMapping(value={"/token-valid"})
    public boolean tokenValid() {
        return this.sessionService.get(this.eruptContextService.getCurrentToken()) != null;
    }

    @GetMapping
    @RequestMapping(value={"/code-img"})
    public void createCode(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("image/jpeg");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        SpecCaptcha captcha = new SpecCaptcha(150, 38, 4);
        this.sessionService.put("eruptAuth:verifyCode:" + IpUtil.getIpAddr(request), captcha.text(), 60L, TimeUnit.SECONDS);
        captcha.out((OutputStream)response.getOutputStream());
    }
}

