/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.service;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import xyz.erupt.annotation.fun.DataProxy;
import xyz.erupt.core.constant.MenuStatus;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.core.util.EruptSpringUtil;
import xyz.erupt.core.util.Erupts;
import xyz.erupt.jpa.dao.EruptDao;
import xyz.erupt.upms.model.EruptMenu;
import xyz.erupt.upms.model.EruptRole;
import xyz.erupt.upms.model.EruptUser;
import xyz.erupt.upms.service.EruptContextService;
import xyz.erupt.upms.service.EruptUserService;
import xyz.erupt.upms.vo.EruptMenuVo;

@Service
public class EruptMenuService
implements DataProxy<EruptMenu> {
    @Resource
    private EruptDao eruptDao;
    @Resource
    private EruptContextService eruptContextService;

    public List<EruptMenuVo> geneMenuListVo(List<EruptMenu> menus) {
        ArrayList<EruptMenuVo> list = new ArrayList<EruptMenuVo>();
        menus.stream().filter(menu -> menu.getStatus().intValue() == MenuStatus.OPEN.getValue()).forEach(menu -> {
            Long pid = null == menu.getParentMenu() ? null : menu.getParentMenu().getId();
            list.add(new EruptMenuVo(menu.getId(), menu.getCode(), menu.getName(), menu.getType(), menu.getValue(), menu.getIcon(), pid));
        });
        return list;
    }

    public List<EruptMenu> getUserAllMenu(EruptUser eruptUser) {
        List menus;
        if (null != eruptUser.getIsAdmin() && eruptUser.getIsAdmin().booleanValue()) {
            menus = this.eruptDao.getEntityManager().createQuery("from EruptMenu order by sort", EruptMenu.class).getResultList();
        } else {
            HashSet menuSet = new HashSet();
            eruptUser.getRoles().stream().filter(EruptRole::getStatus).map(EruptRole::getMenus).forEach(menuSet::addAll);
            menus = menuSet.stream().sorted(Comparator.comparing(EruptMenu::getSort, Comparator.nullsFirst(Integer::compareTo))).collect(Collectors.toList());
        }
        return menus;
    }

    public void addBehavior(EruptMenu eruptMenu) {
        Integer obj = (Integer)this.eruptDao.getEntityManager().createQuery("select max(sort) from " + EruptMenu.class.getSimpleName()).getSingleResult();
        Optional.ofNullable(obj).ifPresent(it -> eruptMenu.setSort(it + 10));
        eruptMenu.setStatus(MenuStatus.OPEN.getValue());
    }

    public void beforeAdd(EruptMenu eruptMenu) {
        eruptMenu.setCode(Erupts.generateCode());
    }

    public void afterAdd(EruptMenu eruptMenu) {
        if (StringUtils.isNotBlank((CharSequence)eruptMenu.getType()) && StringUtils.isBlank((CharSequence)eruptMenu.getValue())) {
            throw new EruptWebApiRuntimeException("When selecting a menu type, the type value cannot be empty");
        }
        EruptUserService eruptUserService = (EruptUserService)EruptSpringUtil.getBean(EruptUserService.class);
        eruptUserService.cacheUserInfo(eruptUserService.getCurrentEruptUser(), this.eruptContextService.getCurrentToken());
    }

    public void afterUpdate(EruptMenu eruptMenu) {
        this.afterAdd(eruptMenu);
    }

    public void afterDelete(EruptMenu eruptMenu) {
        this.afterAdd(eruptMenu);
    }
}

