/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.service;

import java.util.Date;
import java.util.Optional;
import javax.annotation.Resource;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import xyz.erupt.core.module.EruptModuleInvoke;
import xyz.erupt.core.module.MetaMenu;
import xyz.erupt.core.util.MD5Util;
import xyz.erupt.core.util.ProjectUtil;
import xyz.erupt.jpa.dao.EruptDao;
import xyz.erupt.upms.model.EruptMenu;
import xyz.erupt.upms.model.EruptUser;

@Service
@Order
public class UpmsDataLoadService
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(UpmsDataLoadService.class);
    @Resource
    private EruptDao eruptDao;
    public static final String DEFAULT_ACCOUNT = "erupt";

    @Transactional
    public void run(String ... args) {
        EruptModuleInvoke.invoke(module -> Optional.ofNullable(module.initMenus()).ifPresent(metaMenus -> new ProjectUtil().projectStartLoaded(module.info().getName(), first -> {
            if (first.booleanValue()) {
                module.initFun();
                for (MetaMenu metaMenu : metaMenus) {
                    metaMenu.setId(((EruptMenu)((Object)((Object)((Object)((Object)this.eruptDao.persistIfNotExist(EruptMenu.class, (Object)EruptMenu.fromMetaMenu(metaMenu), "code", metaMenu.getCode())))))).getId());
                }
            }
        })));
        new ProjectUtil().projectStartLoaded("erupt-upms-user", first -> {
            if (first.booleanValue()) {
                if (this.eruptDao.queryEntityList(EruptUser.class, "isAdmin = true").size() <= 0) {
                    EruptUser eruptUser = new EruptUser();
                    eruptUser.setIsAdmin(true);
                    eruptUser.setIsMd5(true);
                    eruptUser.setStatus(true);
                    eruptUser.setCreateTime(new Date());
                    eruptUser.setAccount(DEFAULT_ACCOUNT);
                    eruptUser.setPassword(MD5Util.digest((String)DEFAULT_ACCOUNT));
                    eruptUser.setName(DEFAULT_ACCOUNT);
                    eruptUser.setResetPwdTime(new Date());
                    this.eruptDao.persistIfNotExist(EruptUser.class, (Object)eruptUser, "account", eruptUser.getAccount());
                }
            } else {
                EruptUser eruptUser = (EruptUser)((Object)((Object)this.eruptDao.queryEntity(EruptUser.class, "account = 'erupt'", null)));
                if (null != eruptUser) {
                    String password = eruptUser.getPassword();
                    if (!eruptUser.getIsMd5().booleanValue()) {
                        password = MD5Util.digest((String)eruptUser.getPassword());
                    }
                    if (MD5Util.digest((String)DEFAULT_ACCOUNT).equals(password)) {
                        log.warn("\u6b63\u5728\u4f7f\u7528\u6846\u67b6\u9ed8\u8ba4\u7528\u6237\u540d\u5bc6\u7801\uff0c\u4e3a\u4e86\u60a8\u7684\u7cfb\u7edf\u5b89\u5168\u8bf7\u5c3d\u5feb\u4fee\u6539\uff01");
                    }
                }
            }
        });
    }
}

