/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.service;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Resource;
import javax.transaction.Transactional;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import xyz.erupt.annotation.sub_erupt.Power;
import xyz.erupt.core.constant.MenuTypeEnum;
import xyz.erupt.core.module.EruptModuleInvoke;
import xyz.erupt.core.module.MetaMenu;
import xyz.erupt.core.prop.EruptProp;
import xyz.erupt.core.prop.InitMethodEnum;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.core.util.MD5Util;
import xyz.erupt.core.util.ProjectUtil;
import xyz.erupt.jpa.dao.EruptDao;
import xyz.erupt.upms.enums.EruptFunPermissions;
import xyz.erupt.upms.model.EruptMenu;
import xyz.erupt.upms.model.EruptUser;
import xyz.erupt.upms.util.UPMSUtil;

@Service
@Order
public class UpmsDataLoadService
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(UpmsDataLoadService.class);
    @Resource
    private EruptDao eruptDao;
    @Resource
    private EruptProp eruptProp;
    public static final String DEFAULT_ACCOUNT = "erupt";

    @Transactional
    public void run(String ... args) {
        Optional.ofNullable(this.eruptDao.getJdbcTemplate().queryForObject("select count(*) from e_upms_user", Integer.class)).ifPresent(it -> {
            if (it <= 0) {
                try {
                    FileUtils.deleteDirectory((File)new File(System.getProperty("user.dir") + "/" + ".erupt"));
                }
                catch (IOException e) {
                    log.error("Table 'e_upms_user' no user data. Re-initialization failed \uff1a" + e.getMessage());
                }
            }
        });
        if (InitMethodEnum.NONE != this.eruptProp.getInitMethodEnum()) {
            EruptModuleInvoke.invoke(module -> Optional.ofNullable(module.initMenus()).ifPresent(metaMenus -> new ProjectUtil().projectStartLoaded(module.info().getName(), first -> {
                Runnable runnable = () -> {
                    module.initFun();
                    for (MetaMenu metaMenu : metaMenus) {
                        EruptMenu eruptMenu = (EruptMenu)((Object)((Object)((Object)((Object)((Object)this.eruptDao.persistIfNotExist(EruptMenu.class, (Object)EruptMenu.fromMetaMenu(metaMenu), "code", metaMenu.getCode()))))));
                        metaMenu.setId(eruptMenu.getId());
                        if (null == eruptMenu.getType() || null == eruptMenu.getValue() || !MenuTypeEnum.TABLE.getCode().equals(eruptMenu.getType()) && !MenuTypeEnum.TREE.getCode().equals(eruptMenu.getType())) continue;
                        AtomicInteger i = new AtomicInteger();
                        Optional.ofNullable(EruptCoreService.getErupt((String)eruptMenu.getValue())).ifPresent(it -> {
                            Power power = it.getErupt().power();
                            for (EruptFunPermissions value : EruptFunPermissions.values()) {
                                if (!value.verifyPower(power)) continue;
                                this.eruptDao.persistIfNotExist(EruptMenu.class, (Object)new EruptMenu(UPMSUtil.getEruptFunPermissionsCode(eruptMenu.getValue(), value), value.getName(), MenuTypeEnum.BUTTON.getCode(), UPMSUtil.getEruptFunPermissionsCode(eruptMenu.getValue(), value), eruptMenu, i.addAndGet(10)), "code", UPMSUtil.getEruptFunPermissionsCode(eruptMenu.getValue(), value));
                            }
                        });
                    }
                };
                switch (this.eruptProp.getInitMethodEnum()) {
                    case EVERY: {
                        runnable.run();
                        break;
                    }
                    case FILE: {
                        if (!first.booleanValue()) break;
                        runnable.run();
                    }
                }
            })));
        }
        new ProjectUtil().projectStartLoaded("erupt-upms-user", first -> {
            if (first.booleanValue() && this.eruptDao.queryEntityList(EruptUser.class, "isAdmin = true").size() <= 0) {
                EruptUser eruptUser = new EruptUser();
                eruptUser.setIsAdmin(true);
                eruptUser.setIsMd5(true);
                eruptUser.setStatus(true);
                eruptUser.setCreateTime(new Date());
                eruptUser.setAccount(DEFAULT_ACCOUNT);
                eruptUser.setPassword(MD5Util.digest((String)DEFAULT_ACCOUNT));
                eruptUser.setName(DEFAULT_ACCOUNT);
                this.eruptDao.persistIfNotExist(EruptUser.class, (Object)eruptUser, "account", eruptUser.getAccount());
            }
        });
    }
}

