/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.service;

import com.google.gson.Gson;
import eu.bitwalker.useragentutils.UserAgent;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import xyz.erupt.core.config.GsonFactory;
import xyz.erupt.core.module.MetaUserinfo;
import xyz.erupt.core.prop.EruptProp;
import xyz.erupt.core.service.EruptApplication;
import xyz.erupt.core.util.DateUtil;
import xyz.erupt.core.util.EruptSpringUtil;
import xyz.erupt.core.util.MD5Util;
import xyz.erupt.core.view.EruptApiModel;
import xyz.erupt.jpa.dao.EruptDao;
import xyz.erupt.upms.base.LoginModel;
import xyz.erupt.upms.fun.EruptLogin;
import xyz.erupt.upms.fun.LoginProxy;
import xyz.erupt.upms.model.EruptMenu;
import xyz.erupt.upms.model.EruptRole;
import xyz.erupt.upms.model.EruptUser;
import xyz.erupt.upms.model.log.EruptLoginLog;
import xyz.erupt.upms.prop.EruptAppProp;
import xyz.erupt.upms.prop.EruptUpmsProp;
import xyz.erupt.upms.service.EruptContextService;
import xyz.erupt.upms.service.EruptMenuService;
import xyz.erupt.upms.service.EruptSessionService;
import xyz.erupt.upms.util.IpUtil;

@Service
public class EruptUserService {
    @Resource
    private EruptSessionService sessionService;
    @Resource
    private HttpServletRequest request;
    @Resource
    private EruptDao eruptDao;
    @Resource
    private EruptAppProp eruptAppProp;
    @Resource
    private EruptProp eruptProp;
    @Resource
    private EruptUpmsProp eruptUpmsProp;
    @Resource
    private EruptContextService eruptContextService;
    @Resource
    private EruptMenuService eruptMenuService;
    private final Gson gson = GsonFactory.getGson();
    public static final String LOGIN_ERROR_HINT = "\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef";

    public void cacheUserInfo(EruptUser eruptUser, String token) {
        List<EruptMenu> eruptMenus = this.eruptMenuService.getUserAllMenu(eruptUser);
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        for (EruptMenu menu : eruptMenus) {
            if (null == menu.getValue()) continue;
            valueMap.put(menu.getValue().toLowerCase().split("\\?")[0], (Object)menu);
        }
        this.sessionService.putMap("eruptAuth:menu-value-map:" + token, valueMap, this.eruptUpmsProp.getExpireTimeByLogin().intValue());
        this.sessionService.put("eruptAuth:menu-view:" + token, this.gson.toJson(this.eruptMenuService.geneMenuListVo(eruptMenus)), this.eruptUpmsProp.getExpireTimeByLogin().intValue());
    }

    public void putUserInfo(EruptUser eruptUser, String token) {
        MetaUserinfo metaUserinfo = new MetaUserinfo();
        metaUserinfo.setId(eruptUser.getId());
        metaUserinfo.setSuperAdmin(eruptUser.getIsAdmin().booleanValue());
        metaUserinfo.setAccount(eruptUser.getAccount());
        metaUserinfo.setUsername(eruptUser.getName());
        metaUserinfo.setRoles(eruptUser.getRoles().stream().map(EruptRole::getCode).collect(Collectors.toList()));
        Optional.ofNullable(eruptUser.getEruptPost()).ifPresent(it -> metaUserinfo.setPost(it.getCode()));
        Optional.ofNullable(eruptUser.getEruptOrg()).ifPresent(it -> metaUserinfo.setOrg(it.getCode()));
        this.sessionService.put("eruptAuth:token:" + token, this.gson.toJson((Object)metaUserinfo), this.eruptUpmsProp.getExpireTimeByLogin().intValue());
    }

    public static LoginProxy findEruptLogin() {
        if (null == EruptApplication.getPrimarySource()) {
            throw new RuntimeException("Not found '@EruptScan' Annotation");
        }
        EruptLogin eruptLogin = EruptApplication.getPrimarySource().getAnnotation(EruptLogin.class);
        if (null != eruptLogin) {
            return (LoginProxy)EruptSpringUtil.getBean(eruptLogin.value());
        }
        return null;
    }

    private boolean loginErrorCountPlus(String account, String ip) {
        String key = "eruptAuth:login-error:" + account + ":" + ip;
        Object loginError = this.sessionService.get(key);
        int loginErrorCount = 0;
        if (null != loginError) {
            loginErrorCount = Integer.parseInt(loginError.toString());
        }
        this.sessionService.put(key, ++loginErrorCount + "", this.eruptUpmsProp.getExpireTimeByLogin().intValue());
        return loginErrorCount >= this.eruptAppProp.getVerifyCodeCount();
    }

    public LoginModel login(String account, String pwd) {
        String requestIp = IpUtil.getIpAddr(this.request);
        EruptUser eruptUser = this.findEruptUserByAccount(account);
        if (null != eruptUser) {
            if (!eruptUser.getStatus().booleanValue()) {
                return new LoginModel(false, "\u8d26\u53f7\u5df2\u9501\u5b9a!");
            }
            if (null != eruptUser.getExpireDate() && eruptUser.getExpireDate().getTime() < System.currentTimeMillis()) {
                return new LoginModel(false, String.format("\u8d26\u53f7\u5728 %s \u5931\u6548", DateUtil.getSimpleFormatDate((Date)eruptUser.getExpireDate())));
            }
            if (StringUtils.isNotBlank((CharSequence)eruptUser.getWhiteIp()) && Arrays.stream(eruptUser.getWhiteIp().split("\n")).noneMatch(ip -> ip.equals(requestIp))) {
                return new LoginModel(false, "\u5f53\u524d ip \u65e0\u6743\u8bbf\u95ee");
            }
            if (this.checkPwd(eruptUser, pwd)) {
                this.request.getSession().invalidate();
                this.sessionService.remove("eruptAuth:login-error:" + account + ":" + requestIp);
                return new LoginModel(true, eruptUser);
            }
            return new LoginModel(false, LOGIN_ERROR_HINT, this.loginErrorCountPlus(account, requestIp));
        }
        return new LoginModel(false, LOGIN_ERROR_HINT, this.loginErrorCountPlus(account, requestIp));
    }

    public boolean checkPwd(EruptUser eruptUser, String pwd) {
        if (this.eruptAppProp.getPwdTransferEncrypt().booleanValue()) {
            String digestPwd = eruptUser.getIsMd5() != false ? eruptUser.getPassword() : MD5Util.digest((String)eruptUser.getPassword());
            String calcPwd = MD5Util.digest((String)(digestPwd + Calendar.getInstance().get(5) + eruptUser.getAccount()));
            return pwd.equalsIgnoreCase(calcPwd);
        }
        if (eruptUser.getIsMd5().booleanValue()) {
            pwd = MD5Util.digest((String)pwd);
        }
        return pwd.equals(eruptUser.getPassword());
    }

    public LocalDateTime getExpireTime() {
        if (this.eruptProp.isRedisSession()) {
            return LocalDateTime.now().plusMinutes(this.eruptUpmsProp.getExpireTimeByLogin().intValue());
        }
        return LocalDateTime.now().plusSeconds(this.request.getSession().getMaxInactiveInterval());
    }

    public boolean checkVerifyCode(String account, String verifyCode) {
        String requestIp = IpUtil.getIpAddr(this.request);
        Object loginError = this.sessionService.get("eruptAuth:login-error:" + account + ":" + requestIp);
        long loginErrorCount = 0L;
        if (null != loginError) {
            loginErrorCount = Long.parseLong(loginError.toString());
        }
        if (loginErrorCount >= (long)this.eruptAppProp.getVerifyCodeCount().intValue()) {
            if (StringUtils.isBlank((CharSequence)verifyCode)) {
                return false;
            }
            Object vc = this.sessionService.get("eruptAuth:verifyCode:" + requestIp);
            this.sessionService.remove("eruptAuth:verifyCode:" + requestIp);
            return vc != null && vc.toString().equalsIgnoreCase(verifyCode);
        }
        return true;
    }

    @Transactional
    public void saveLoginLog(EruptUser user, String token) {
        UserAgent userAgent = UserAgent.parseUserAgentString((String)this.request.getHeader("User-Agent"));
        EruptLoginLog loginLog = new EruptLoginLog();
        loginLog.setToken(token);
        loginLog.setUserName(user.getName());
        loginLog.setLoginTime(new Date());
        loginLog.setIp(IpUtil.getIpAddr(this.request));
        loginLog.setSystemName(userAgent.getOperatingSystem().getName());
        loginLog.setRegion(IpUtil.getCityInfo(loginLog.getIp()));
        loginLog.setBrowser(userAgent.getBrowser().getName() + " " + (userAgent.getBrowserVersion() == null ? "" : userAgent.getBrowserVersion().getMajorVersion()));
        loginLog.setDeviceType(userAgent.getOperatingSystem().getDeviceType().getName());
        this.eruptDao.getEntityManager().persist((Object)loginLog);
    }

    @Transactional
    public EruptApiModel changePwd(String account, String pwd, String newPwd, String newPwd2) {
        if (!newPwd.equals(newPwd2)) {
            return EruptApiModel.errorNoInterceptMessage((String)"\u4fee\u6539\u5931\u8d25\uff0c\u65b0\u5bc6\u7801\u4e0e\u786e\u8ba4\u5bc6\u7801\u4e0d\u5339\u914d");
        }
        EruptUser eruptUser = this.findEruptUserByAccount(account);
        LoginProxy loginProxy = EruptUserService.findEruptLogin();
        if (null != loginProxy) {
            loginProxy.beforeChangePwd(eruptUser, newPwd);
        }
        if (eruptUser.getIsMd5().booleanValue()) {
            pwd = MD5Util.digest((String)pwd);
            newPwd = MD5Util.digest((String)newPwd);
        }
        if (eruptUser.getPassword().equals(pwd)) {
            if (newPwd.equals(eruptUser.getPassword())) {
                return EruptApiModel.errorNoInterceptMessage((String)"\u4fee\u6539\u5931\u8d25\uff0c\u65b0\u5bc6\u7801\u4e0d\u80fd\u548c\u539f\u59cb\u5bc6\u7801\u4e00\u6837");
            }
            eruptUser.setPassword(newPwd);
            eruptUser.setResetPwdTime(new Date());
            this.eruptDao.getEntityManager().merge((Object)eruptUser);
            if (null != loginProxy) {
                loginProxy.afterChangePwd(eruptUser, pwd, newPwd);
            }
            return EruptApiModel.successApi();
        }
        return EruptApiModel.errorNoInterceptMessage((String)"\u5bc6\u7801\u9519\u8bef");
    }

    private EruptUser findEruptUserByAccount(final String account) {
        return (EruptUser)((Object)this.eruptDao.queryEntity(EruptUser.class, "account = :account", (Map)new HashMap<String, Object>(1){
            {
                super(initialCapacity);
                this.put("account", account);
            }
        }));
    }

    public EruptMenu getEruptMenuByValue(String menuValue) {
        return this.sessionService.getMapValue("eruptAuth:menu-value-map:" + this.eruptContextService.getCurrentToken(), menuValue.toLowerCase(), EruptMenu.class);
    }

    public List<String> getEruptMenuValues() {
        return this.sessionService.getMapKeys("eruptAuth:menu-value-map:" + this.eruptContextService.getCurrentToken());
    }

    public Map<String, Boolean> getEruptMenuValuesMap() {
        return this.getEruptMenuValues().stream().collect(Collectors.toMap(it -> it, it -> true));
    }

    public Long getCurrentUid() {
        MetaUserinfo metaUserinfo = this.getSimpleUserInfo();
        return null == metaUserinfo ? null : metaUserinfo.getId();
    }

    public MetaUserinfo getSimpleUserInfo() {
        Object info = this.sessionService.get("eruptAuth:token:" + this.eruptContextService.getCurrentToken());
        return null == info ? null : (MetaUserinfo)this.gson.fromJson(info.toString(), MetaUserinfo.class);
    }

    public MetaUserinfo getSimpleUserInfoByToken(String token) {
        Object info = this.sessionService.get("eruptAuth:token:" + token);
        return null == info ? null : (MetaUserinfo)this.gson.fromJson(info.toString(), MetaUserinfo.class);
    }

    public EruptUser getCurrentEruptUser() {
        Long uid = this.getCurrentUid();
        return null == uid ? null : (EruptUser)((Object)this.eruptDao.getEntityManager().find(EruptUser.class, (Object)uid));
    }
}

