/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.looker;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.springframework.stereotype.Component;
import xyz.erupt.annotation.EruptField;
import xyz.erupt.annotation.PreDataProxy;
import xyz.erupt.annotation.config.EruptSmartSkipSerialize;
import xyz.erupt.annotation.fun.DataProxy;
import xyz.erupt.annotation.query.Condition;
import xyz.erupt.annotation.sub_field.Edit;
import xyz.erupt.annotation.sub_field.EditType;
import xyz.erupt.annotation.sub_field.Readonly;
import xyz.erupt.annotation.sub_field.View;
import xyz.erupt.annotation.sub_field.sub_edit.DateType;
import xyz.erupt.core.context.MetaContext;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.core.service.I18NTranslateService;
import xyz.erupt.jpa.model.BaseModel;
import xyz.erupt.upms.model.EruptUser;
import xyz.erupt.upms.model.EruptUserPostVo;
import xyz.erupt.upms.service.EruptUserService;

@MappedSuperclass
@PreDataProxy(value=LookerPostLevel.class)
@Component
public class LookerPostLevel
extends BaseModel
implements DataProxy<LookerPostLevel> {
    @ManyToOne
    @EruptField(views={@View(title="\u521b\u5efa\u4eba", column="name"), @View(title="\u6240\u5c5e\u7ec4\u7ec7", column="eruptOrg.name"), @View(title="\u5c97\u4f4d", column="eruptPost.name")}, edit=@Edit(title="\u521b\u5efa\u4eba", readonly=@Readonly, type=EditType.REFERENCE_TABLE))
    @EruptSmartSkipSerialize
    private EruptUserPostVo createUser;
    @EruptField(views={@View(title="\u521b\u5efa\u65f6\u95f4", sortable=true)}, edit=@Edit(title="\u521b\u5efa\u65f6\u95f4", readonly=@Readonly, dateType=@DateType(type=DateType.Type.DATE_TIME)))
    @EruptSmartSkipSerialize
    private Date createTime;
    @EruptSmartSkipSerialize
    private Date updateTime;
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    @EruptSmartSkipSerialize
    private EruptUser updateUser;
    @Resource
    @Transient
    private EruptUserService eruptUserService;
    @Resource
    @Transient
    private I18NTranslateService i18NTranslateService;

    public String beforeFetch(List<Condition> conditions) {
        EruptUser eruptUser = this.eruptUserService.getCurrentEruptUser();
        if (eruptUser.getIsAdmin().booleanValue()) {
            return null;
        }
        if (null == eruptUser.getEruptOrg() || null == eruptUser.getEruptPost()) {
            throw new EruptWebApiRuntimeException(eruptUser.getName() + " " + this.i18NTranslateService.translate("\u672a\u7ed1\u5b9a\u7684\u5c97\u4f4d\u65e0\u6cd5\u67e5\u770b\u6570\u636e", new Object[0]));
        }
        String eruptName = MetaContext.getErupt().getName();
        return "(" + eruptName + ".createUser.id = " + this.eruptUserService.getCurrentUid() + " or " + eruptName + ".createUser.eruptOrg.id = " + eruptUser.getEruptOrg().getId() + " and " + eruptName + ".createUser.eruptPost.weight < " + eruptUser.getEruptPost().getWeight() + ")";
    }

    public void beforeAdd(LookerPostLevel lookerPostLevel) {
        lookerPostLevel.setCreateTime(new Date());
        lookerPostLevel.setCreateUser(new EruptUserPostVo(this.eruptUserService.getCurrentUid()));
    }

    public void beforeUpdate(LookerPostLevel lookerPostLevel) {
        lookerPostLevel.setUpdateTime(new Date());
        lookerPostLevel.setUpdateUser(new EruptUser(this.eruptUserService.getCurrentUid()));
    }

    public EruptUserPostVo getCreateUser() {
        return this.createUser;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public EruptUser getUpdateUser() {
        return this.updateUser;
    }

    public EruptUserService getEruptUserService() {
        return this.eruptUserService;
    }

    public I18NTranslateService getI18NTranslateService() {
        return this.i18NTranslateService;
    }

    public void setCreateUser(EruptUserPostVo createUser) {
        this.createUser = createUser;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @JsonIgnore
    public void setUpdateUser(EruptUser updateUser) {
        this.updateUser = updateUser;
    }

    public void setEruptUserService(EruptUserService eruptUserService) {
        this.eruptUserService = eruptUserService;
    }

    public void setI18NTranslateService(I18NTranslateService i18NTranslateService) {
        this.i18NTranslateService = i18NTranslateService;
    }
}

