/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.model;

import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import xyz.erupt.annotation.fun.DataProxy;
import xyz.erupt.core.exception.EruptApiErrorTip;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.core.i18n.I18nTranslate;
import xyz.erupt.core.util.MD5Util;
import xyz.erupt.core.view.EruptApiModel;
import xyz.erupt.upms.model.EruptUser;
import xyz.erupt.upms.service.EruptUserService;

@Component
public class EruptUserDataProxy
implements DataProxy<EruptUser> {
    @Resource
    private EruptUserService eruptUserService;

    public void beforeAdd(EruptUser eruptUser) {
        this.checkDataLegal(eruptUser);
        if (StringUtils.isBlank((CharSequence)eruptUser.getPasswordA())) {
            throw new EruptApiErrorTip(EruptApiModel.Status.WARNING, I18nTranslate.$translate((String)"upms.pwd_required", (Object[])new Object[0]), EruptApiModel.PromptWay.MESSAGE);
        }
        if (eruptUser.getPasswordA().equals(eruptUser.getPasswordB())) {
            if (eruptUser.getIsMd5().booleanValue()) {
                eruptUser.setPassword(MD5Util.digest((String)eruptUser.getPasswordA()));
            } else {
                eruptUser.setPassword(eruptUser.getPasswordA());
            }
        } else {
            throw new EruptWebApiRuntimeException(I18nTranslate.$translate((String)"upms.pwd_two_inconsistent", (Object[])new Object[0]));
        }
    }

    public void beforeUpdate(EruptUser eruptUser) {
        this.checkDataLegal(eruptUser);
    }

    private void checkDataLegal(EruptUser eruptUser) {
        if (eruptUser.getEruptPost() != null && eruptUser.getEruptOrg() == null) {
            throw new EruptWebApiRuntimeException(I18nTranslate.$translate((String)"upms.position_no_org", (Object[])new Object[0]));
        }
        EruptUser curr = this.eruptUserService.getCurrentEruptUser();
        if (eruptUser.getIsAdmin().booleanValue() && (null == curr.getIsAdmin() || !curr.getIsAdmin().booleanValue())) {
            throw new EruptWebApiRuntimeException(I18nTranslate.$translate((String)"upms.not_super_admin-unable_add", (Object[])new Object[0]));
        }
    }
}

