/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.service;

import com.google.gson.Gson;
import eu.bitwalker.useragentutils.UserAgent;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import xyz.erupt.core.config.GsonFactory;
import xyz.erupt.core.i18n.I18nTranslate;
import xyz.erupt.core.module.MetaUserinfo;
import xyz.erupt.core.prop.EruptProp;
import xyz.erupt.core.service.EruptApplication;
import xyz.erupt.core.util.DateUtil;
import xyz.erupt.core.util.EruptSpringUtil;
import xyz.erupt.core.util.MD5Util;
import xyz.erupt.core.view.EruptApiModel;
import xyz.erupt.jpa.dao.EruptDao;
import xyz.erupt.upms.base.LoginModel;
import xyz.erupt.upms.fun.EruptLogin;
import xyz.erupt.upms.fun.LoginProxy;
import xyz.erupt.upms.model.EruptMenu;
import xyz.erupt.upms.model.EruptUser;
import xyz.erupt.upms.model.log.EruptLoginLog;
import xyz.erupt.upms.prop.EruptAppProp;
import xyz.erupt.upms.prop.EruptUpmsProp;
import xyz.erupt.upms.service.EruptContextService;
import xyz.erupt.upms.service.EruptSessionService;
import xyz.erupt.upms.util.IpUtil;

@Service
public class EruptUserService {
    private static final Logger log = LoggerFactory.getLogger(EruptUserService.class);
    @Resource
    private EruptSessionService sessionService;
    @Resource
    private HttpServletRequest request;
    @Resource
    private EruptDao eruptDao;
    @Resource
    private EruptAppProp eruptAppProp;
    @Resource
    private EruptProp eruptProp;
    @Resource
    private EruptUpmsProp eruptUpmsProp;
    @Resource
    private EruptContextService eruptContextService;
    private final Gson gson = GsonFactory.getGson();

    public static LoginProxy findEruptLogin() {
        if (null == EruptApplication.getPrimarySource()) {
            throw new RuntimeException("Not found '@EruptScan' Annotation");
        }
        EruptLogin eruptLogin = EruptApplication.getPrimarySource().getAnnotation(EruptLogin.class);
        if (null != eruptLogin) {
            return (LoginProxy)EruptSpringUtil.getBean(eruptLogin.value());
        }
        return null;
    }

    private boolean loginErrorCountPlus(String account, String ip) {
        String key = "erupt-auth:login-error:" + account + ":" + ip;
        Object loginError = this.sessionService.get(key);
        int loginErrorCount = 0;
        if (null != loginError) {
            loginErrorCount = Integer.parseInt(loginError.toString());
        }
        this.sessionService.put(key, ++loginErrorCount + "", this.eruptUpmsProp.getExpireTimeByLogin().intValue());
        return loginErrorCount >= this.eruptAppProp.getVerifyCodeCount();
    }

    public LoginModel login(String account, String pwd) {
        String requestIp = IpUtil.getIpAddr(this.request);
        EruptUser eruptUser = this.findEruptUserByAccount(account);
        if (null != eruptUser) {
            if (!eruptUser.getStatus().booleanValue()) {
                return new LoginModel(false, "\u8d26\u53f7\u5df2\u9501\u5b9a!");
            }
            if (null != eruptUser.getExpireDate() && eruptUser.getExpireDate().getTime() < System.currentTimeMillis()) {
                return new LoginModel(false, String.format("\u8d26\u53f7\u5728 %s \u5931\u6548", DateUtil.getSimpleFormatDate((Date)eruptUser.getExpireDate())));
            }
            if (StringUtils.isNotBlank((CharSequence)eruptUser.getWhiteIp()) && Arrays.stream(eruptUser.getWhiteIp().split("\n")).noneMatch(ip -> ip.equals(requestIp))) {
                return new LoginModel(false, "\u5f53\u524d ip \u65e0\u6743\u8bbf\u95ee");
            }
            if (this.checkPwd(eruptUser.getAccount(), eruptUser.getPassword(), eruptUser.getIsMd5(), pwd)) {
                this.request.getSession().invalidate();
                this.sessionService.remove("erupt-auth:login-error:" + account + ":" + requestIp);
                return new LoginModel(true, eruptUser);
            }
        }
        return new LoginModel(false, I18nTranslate.$translate((String)"upms.account_pwd_error"), this.loginErrorCountPlus(account, requestIp));
    }

    public boolean checkPwd(String account, String password, boolean isMd5, String inputPwd) {
        if (this.eruptAppProp.getPwdTransferEncrypt().booleanValue()) {
            String digestPwd = isMd5 ? password : MD5Util.digest((String)password);
            String calcPwd = MD5Util.digest((String)(digestPwd + account));
            return inputPwd.equalsIgnoreCase(calcPwd);
        }
        if (isMd5) {
            inputPwd = MD5Util.digest((String)inputPwd);
        }
        return inputPwd.equals(password);
    }

    public LocalDateTime getExpireTime() {
        if (this.eruptProp.isRedisSession()) {
            return LocalDateTime.now().plusMinutes(this.eruptUpmsProp.getExpireTimeByLogin().intValue());
        }
        return LocalDateTime.now().plusSeconds(this.request.getSession().getMaxInactiveInterval());
    }

    public boolean checkVerifyCode(String account, String verifyCode, String verifyCodeMark) {
        String requestIp = IpUtil.getIpAddr(this.request);
        Object loginError = this.sessionService.get("erupt-auth:login-error:" + account + ":" + requestIp);
        long loginErrorCount = 0L;
        if (null != loginError) {
            loginErrorCount = Long.parseLong(loginError.toString());
        }
        if (loginErrorCount >= (long)this.eruptAppProp.getVerifyCodeCount().intValue()) {
            if (StringUtils.isBlank((CharSequence)verifyCode)) {
                return false;
            }
            String key = "erupt-auth:verify-code:" + verifyCodeMark;
            Object vc = this.sessionService.get(key);
            this.sessionService.remove(key);
            return vc != null && vc.toString().equalsIgnoreCase(verifyCode);
        }
        return true;
    }

    @Transactional
    public void saveLoginLog(EruptUser user, String token) {
        UserAgent userAgent = UserAgent.parseUserAgentString((String)this.request.getHeader("User-Agent"));
        EruptLoginLog loginLog = new EruptLoginLog();
        loginLog.setToken(token);
        loginLog.setUserName(user.getName());
        loginLog.setLoginTime(new Date());
        loginLog.setIp(IpUtil.getIpAddr(this.request));
        loginLog.setSystemName(userAgent.getOperatingSystem().getName());
        loginLog.setRegion(IpUtil.getCityInfo(loginLog.getIp()));
        loginLog.setBrowser(userAgent.getBrowser().getName() + " " + (userAgent.getBrowserVersion() == null ? "" : userAgent.getBrowserVersion().getMajorVersion()));
        loginLog.setDeviceType(userAgent.getOperatingSystem().getDeviceType().getName());
        this.eruptDao.getEntityManager().persist((Object)loginLog);
    }

    @Transactional
    public EruptApiModel changePwd(String account, String pwd, String newPwd, String newPwd2) {
        if (!newPwd.equals(newPwd2)) {
            return EruptApiModel.errorNoInterceptMessage((String)"\u4fee\u6539\u5931\u8d25\uff0c\u65b0\u5bc6\u7801\u4e0e\u786e\u8ba4\u5bc6\u7801\u4e0d\u5339\u914d");
        }
        EruptUser eruptUser = this.findEruptUserByAccount(account);
        LoginProxy loginProxy = EruptUserService.findEruptLogin();
        if (null != loginProxy) {
            loginProxy.beforeChangePwd(eruptUser, newPwd);
        }
        if (eruptUser.getIsMd5().booleanValue()) {
            pwd = MD5Util.digest((String)pwd);
            newPwd = MD5Util.digest((String)newPwd);
        }
        if (eruptUser.getPassword().equals(pwd)) {
            if (newPwd.equals(eruptUser.getPassword())) {
                return EruptApiModel.errorNoInterceptMessage((String)"\u4fee\u6539\u5931\u8d25\uff0c\u65b0\u5bc6\u7801\u4e0d\u80fd\u548c\u539f\u59cb\u5bc6\u7801\u4e00\u6837");
            }
            eruptUser.setPassword(newPwd);
            eruptUser.setResetPwdTime(new Date());
            this.eruptDao.getEntityManager().merge((Object)eruptUser);
            if (null != loginProxy) {
                loginProxy.afterChangePwd(eruptUser, pwd, newPwd);
            }
            return EruptApiModel.successApi();
        }
        return EruptApiModel.errorNoInterceptMessage((String)"\u5bc6\u7801\u9519\u8bef");
    }

    private EruptUser findEruptUserByAccount(String account) {
        return (EruptUser)((Object)this.eruptDao.lambdaQuery(EruptUser.class).eq(EruptUser::getAccount, (Object)account).one());
    }

    public String getCurrentAccount() {
        Object account = this.sessionService.get("erupt-auth:token:" + this.eruptContextService.getCurrentToken());
        return null == account ? null : account.toString();
    }

    public EruptMenu getEruptMenuByValue(String menuValue) {
        return this.sessionService.getMapValue("erupt-auth:menu-value-map:" + this.eruptContextService.getCurrentToken(), menuValue.toLowerCase(), EruptMenu.class);
    }

    public List<String> getEruptMenuValues() {
        return this.sessionService.getMapKeys("erupt-auth:menu-value-map:" + this.eruptContextService.getCurrentToken());
    }

    public Map<String, Boolean> getEruptMenuValuesMap() {
        return this.getEruptMenuValues().stream().collect(Collectors.toMap(it -> it, it -> true));
    }

    public Long getCurrentUid() {
        MetaUserinfo metaUserinfo = this.getSimpleUserInfo();
        return null == metaUserinfo ? null : metaUserinfo.getId();
    }

    public MetaUserinfo getSimpleUserInfo() {
        Object info = this.sessionService.get("erupt-auth:user:" + this.eruptContextService.getCurrentToken());
        return null == info ? null : (MetaUserinfo)this.gson.fromJson(info.toString(), MetaUserinfo.class);
    }

    public MetaUserinfo getSimpleUserInfoByToken(String token) {
        Object info = this.sessionService.get("erupt-auth:user:" + token);
        return null == info ? null : (MetaUserinfo)this.gson.fromJson(info.toString(), MetaUserinfo.class);
    }

    public EruptUser getCurrentEruptUser() {
        Long uid = this.getCurrentUid();
        return null == uid ? null : (EruptUser)((Object)this.eruptDao.getEntityManager().find(EruptUser.class, (Object)uid));
    }
}

