/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.service;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import xyz.erupt.annotation.fun.DataProxy;
import xyz.erupt.core.constant.MenuStatus;
import xyz.erupt.core.constant.MenuTypeEnum;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.core.service.EruptCoreService;
import xyz.erupt.core.util.Erupts;
import xyz.erupt.core.view.EruptModel;
import xyz.erupt.jpa.dao.EruptDao;
import xyz.erupt.upms.enums.EruptFunPermissions;
import xyz.erupt.upms.model.EruptMenu;
import xyz.erupt.upms.model.EruptRole;
import xyz.erupt.upms.model.EruptUser;
import xyz.erupt.upms.service.EruptContextService;
import xyz.erupt.upms.service.EruptTokenService;
import xyz.erupt.upms.service.EruptUserService;
import xyz.erupt.upms.util.UPMSUtil;

@Service
public class EruptMenuService
implements DataProxy<EruptMenu> {
    @Resource
    private EruptDao eruptDao;
    @Resource
    private EruptContextService eruptContextService;
    @Resource
    private EruptUserService eruptUserService;
    @Resource
    private EruptTokenService eruptTokenService;

    public List<EruptMenu> getUserAllMenu(EruptUser eruptUser) {
        if (null != eruptUser.getIsAdmin() && eruptUser.getIsAdmin().booleanValue()) {
            return this.eruptDao.lambdaQuery(EruptMenu.class).orderBy(EruptMenu::getSort).list();
        }
        HashSet menuSet = new HashSet();
        eruptUser.getRoles().stream().filter(EruptRole::getStatus).map(EruptRole::getMenus).forEach(menuSet::addAll);
        return menuSet.stream().filter(it -> it.getStatus().intValue() != MenuStatus.DISABLE.getValue()).collect(Collectors.toList());
    }

    public void addBehavior(EruptMenu eruptMenu) {
        Integer sort = (Integer)this.eruptDao.lambdaQuery(EruptMenu.class).max(EruptMenu::getSort);
        Optional.ofNullable(sort).ifPresent(it -> eruptMenu.setSort(it + 10));
        eruptMenu.setStatus(MenuStatus.OPEN.getValue());
    }

    public void beforeAdd(EruptMenu eruptMenu) {
        if (null == eruptMenu.getCode()) {
            eruptMenu.setCode(Erupts.generateCode());
        }
        if (StringUtils.isNotBlank((CharSequence)eruptMenu.getType()) && StringUtils.isBlank((CharSequence)eruptMenu.getValue())) {
            throw new EruptWebApiRuntimeException("When selecting a menu type, the type value cannot be empty");
        }
        if (StringUtils.isNotBlank((CharSequence)eruptMenu.getValue()) && StringUtils.isBlank((CharSequence)eruptMenu.getType())) {
            throw new EruptWebApiRuntimeException("When has menu value, the menu type cannot be empty");
        }
    }

    public void beforeUpdate(EruptMenu eruptMenu) {
        this.beforeAdd(eruptMenu);
    }

    public void flushMenuCache() {
        this.eruptTokenService.loginToken(this.eruptUserService.getCurrentEruptUser(), this.eruptContextService.getCurrentToken());
    }

    public void afterAdd(EruptMenu eruptMenu) {
        if (null != eruptMenu.getValue() && (MenuTypeEnum.TABLE.getCode().equals(eruptMenu.getType()) || MenuTypeEnum.TREE.getCode().equals(eruptMenu.getType()))) {
            int i = 0;
            EruptModel eruptModel = EruptCoreService.getErupt((String)eruptMenu.getValue());
            for (EruptFunPermissions value : EruptFunPermissions.values()) {
                if (eruptModel != null && !value.verifyPower(eruptModel.getErupt().power())) continue;
                this.eruptDao.persist((Object)new EruptMenu(Erupts.generateCode(), value.getName(), MenuTypeEnum.BUTTON.getCode(), UPMSUtil.getEruptFunPermissionsCode(eruptMenu.getValue(), value), eruptMenu, i += 10));
            }
        }
        this.flushMenuCache();
    }

    public void afterUpdate(EruptMenu eruptMenu) {
        List subMenus = this.eruptDao.lambdaQuery(EruptMenu.class).addCondition("parentMenu.id = " + eruptMenu.getId()).list();
        for (EruptMenu subMenu : subMenus) {
            if (null == subMenu.getValue() || !subMenu.getValue().contains("@")) continue;
            String[] arr = subMenu.getValue().split("@");
            try {
                EruptFunPermissions.valueOf(arr[1]);
                if (arr[0].equals(eruptMenu.getValue())) continue;
                subMenu.setValue(eruptMenu.getValue() + "@" + arr[1]);
                this.eruptDao.merge((Object)subMenu);
            }
            catch (Exception exception) {}
        }
    }

    public void beforeDelete(EruptMenu eruptMenu) {
        this.eruptDao.getJdbcTemplate().update("delete from e_upms_role_menu where menu_id = " + eruptMenu.getId());
    }

    public void afterDelete(EruptMenu eruptMenu) {
        this.flushMenuCache();
    }
}

