/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.service;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import xyz.erupt.core.config.GsonFactory;
import xyz.erupt.core.constant.MenuStatus;
import xyz.erupt.core.module.MetaMenu;
import xyz.erupt.core.module.MetaUserinfo;
import xyz.erupt.core.prop.EruptProp;
import xyz.erupt.core.util.EruptSpringUtil;
import xyz.erupt.upms.constant.SessionKey;
import xyz.erupt.upms.model.EruptMenu;
import xyz.erupt.upms.model.EruptUser;
import xyz.erupt.upms.prop.EruptUpmsProp;
import xyz.erupt.upms.service.EruptMenuService;
import xyz.erupt.upms.service.EruptSessionService;
import xyz.erupt.upms.vo.EruptMenuVo;

@Service
public class EruptTokenService {
    private static final Logger log = LoggerFactory.getLogger(EruptTokenService.class);
    @Resource
    private EruptUpmsProp eruptUpmsProp;
    @Resource
    private EruptSessionService eruptSessionService;
    @Resource
    private EruptProp eruptProp;
    @Resource
    private HttpServletRequest request;

    public void loginToken(MetaUserinfo metaUserinfo, List<MetaMenu> metaMenus, String token, Integer tokenExpire) {
        HashMap<String, Object> eruptMenuMap = new HashMap<String, Object>();
        ArrayList eruptMenuVos = new ArrayList();
        metaMenus.stream().sorted(Comparator.comparing(MetaMenu::getSort, Comparator.nullsFirst(Integer::compareTo))).forEach(menu -> {
            if (menu.getStatus() != MenuStatus.DISABLE) {
                if (null != menu.getValue()) {
                    eruptMenuMap.put(menu.getValue().toLowerCase().split("\\?")[0], (Object)EruptMenu.fromMetaMenu(menu));
                }
                if (menu.getStatus() == MenuStatus.OPEN) {
                    eruptMenuVos.add(EruptMenuVo.fromMetaMenu(menu));
                }
            }
        });
        this.eruptSessionService.putMap("erupt-auth:menu-value-map:" + token, eruptMenuMap, tokenExpire.intValue());
        this.eruptSessionService.put("erupt-auth:menu-view:" + token, GsonFactory.getGson().toJson(eruptMenuVos), tokenExpire.intValue());
        this.eruptSessionService.put("erupt-auth:user:" + token, GsonFactory.getGson().toJson((Object)metaUserinfo), tokenExpire.intValue());
        this.eruptSessionService.put("erupt-auth:token:" + token, metaUserinfo.getAccount(), tokenExpire.intValue());
    }

    public boolean tokenExist(String token) {
        return this.eruptSessionService.exist("erupt-auth:token:" + token);
    }

    public void loginToken(EruptUser eruptUser, String token, Integer tokenExpire) {
        ArrayList<MetaMenu> metaMenus = new ArrayList<MetaMenu>();
        List<EruptMenu> eruptMenus = ((EruptMenuService)EruptSpringUtil.getBean(EruptMenuService.class)).getUserAllMenu(eruptUser);
        eruptMenus.forEach(menu -> metaMenus.add(menu.toMetaMenu()));
        this.loginToken(eruptUser.toMetaUser(), metaMenus, token, tokenExpire);
    }

    public void loginToken(EruptUser eruptUser, String token) {
        this.loginToken(eruptUser, token, this.eruptUpmsProp.getExpireTimeByLogin());
    }

    public void logoutToken(String name, String token) {
        if (!this.eruptProp.isRedisSession()) {
            this.request.getSession().invalidate();
        }
        for (String uk : SessionKey.USER_KEY_GROUP) {
            this.eruptSessionService.remove(uk + token);
        }
        log.info("logout erupt-token: {} \u2192 {}", (Object)name, (Object)token);
    }
}

