/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.model.data_proxy;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import xyz.erupt.annotation.fun.DataProxy;
import xyz.erupt.annotation.fun.OperationHandler;
import xyz.erupt.jpa.dao.EruptDao;
import xyz.erupt.linq.lambda.LambdaSee;
import xyz.erupt.upms.model.EruptOpenApi;
import xyz.erupt.upms.service.EruptTokenService;
import xyz.erupt.upms.service.EruptUserService;

@Component
public class EruptOpenApiDataProxy
implements DataProxy<EruptOpenApi>,
OperationHandler<EruptOpenApi, Void> {
    @Resource
    private EruptUserService eruptUserService;
    @Resource
    private EruptDao eruptDao;
    @Resource
    private EruptTokenService eruptTokenService;

    public void beforeAdd(EruptOpenApi eruptOpenApi) {
        eruptOpenApi.setAppid("es" + RandomStringUtils.random((int)14, (String)"abcdef0123456789"));
        eruptOpenApi.setSecret(RandomStringUtils.randomAlphanumeric((int)24).toUpperCase());
    }

    public void afterUpdate(EruptOpenApi eruptOpenApi) {
        if (!eruptOpenApi.getStatus().booleanValue()) {
            this.logoutToken(eruptOpenApi);
            eruptOpenApi.setCurrentToken(null);
        }
    }

    public void afterDelete(EruptOpenApi eruptOpenApi) {
        this.logoutToken(eruptOpenApi);
    }

    public void afterFetch(Collection<Map<String, Object>> list) {
        String secretField = LambdaSee.field(EruptOpenApi::getSecret);
        for (Map<String, Object> map : list) {
            String secret = map.get(secretField).toString();
            map.put(secretField, secret.substring(0, 4) + "********" + secret.substring(secret.length() - 4));
        }
    }

    private void logoutToken(EruptOpenApi eruptOpenApi) {
        Optional.ofNullable(eruptOpenApi.getCurrentToken()).ifPresent(it -> this.eruptTokenService.logoutToken(eruptOpenApi.getName(), eruptOpenApi.getCurrentToken()));
    }

    @Transactional
    public String exec(List<EruptOpenApi> data, Void unused, String[] param) {
        EruptOpenApi eruptOpenApi = (EruptOpenApi)((Object)this.eruptDao.find(EruptOpenApi.class, (Object)data.get(0).getId()));
        eruptOpenApi.setSecret(RandomStringUtils.randomAlphanumeric((int)24).toUpperCase());
        return "msg.info('new secret:" + eruptOpenApi.getSecret() + "')";
    }
}

