/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.controller;

import com.google.gson.reflect.TypeToken;
import com.wf.captcha.SpecCaptcha;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import xyz.erupt.core.annotation.EruptRouter;
import xyz.erupt.core.i18n.I18nTranslate;
import xyz.erupt.core.util.EruptInformation;
import xyz.erupt.core.util.Erupts;
import xyz.erupt.core.util.SecretUtil;
import xyz.erupt.core.view.EruptApiModel;
import xyz.erupt.upms.base.LoginModel;
import xyz.erupt.upms.constant.SessionKey;
import xyz.erupt.upms.fun.LoginProxy;
import xyz.erupt.upms.model.EruptUser;
import xyz.erupt.upms.prop.EruptAppProp;
import xyz.erupt.upms.prop.EruptUpmsProp;
import xyz.erupt.upms.service.EruptContextService;
import xyz.erupt.upms.service.EruptSessionService;
import xyz.erupt.upms.service.EruptUserService;
import xyz.erupt.upms.vo.EruptMenuVo;
import xyz.erupt.upms.vo.EruptUserinfoVo;

@RestController
@RequestMapping(value={"/erupt-api"})
public class EruptUserController {
    @Resource
    private EruptUserService eruptUserService;
    @Resource
    private EruptSessionService sessionService;
    @Resource
    private EruptAppProp eruptAppProp;
    @Resource
    private EruptContextService eruptContextService;
    @Resource
    private HttpServletRequest request;
    @Resource
    private EruptUpmsProp eruptUpmsProp;

    @GetMapping(value={"/erupt-app"})
    public EruptAppProp eruptApp() {
        this.eruptAppProp.setHash(this.hashCode());
        this.eruptAppProp.setVersion(EruptInformation.getEruptVersion());
        return this.eruptAppProp;
    }

    @GetMapping(value={"/login"})
    public LoginModel login(@RequestParam String account, @RequestParam String pwd, @RequestParam(required=false) String verifyCode, @RequestParam(required=false) String verifyCodeMark) {
        EruptUser eruptUser;
        LoginModel loginModel;
        if (!this.eruptUserService.checkVerifyCode(account, verifyCode, verifyCodeMark)) {
            LoginModel loginModel2 = new LoginModel();
            loginModel2.setUseVerifyCode(true);
            loginModel2.setReason("\u9a8c\u8bc1\u7801\u9519\u8bef");
            loginModel2.setPass(false);
            return loginModel2;
        }
        LoginProxy loginProxy = EruptUserService.findEruptLogin();
        if (null == loginProxy) {
            loginModel = this.eruptUserService.login(account, pwd);
        } else {
            loginModel = new LoginModel();
            try {
                eruptUser = loginProxy.login(account, pwd);
                if (null == eruptUser) {
                    loginModel.setReason("\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef");
                    loginModel.setPass(false);
                } else {
                    loginModel.setEruptUser(eruptUser);
                    loginModel.setPass(true);
                }
            }
            catch (Exception e) {
                if (0 == this.eruptAppProp.getVerifyCodeCount()) {
                    loginModel.setUseVerifyCode(true);
                }
                loginModel.setReason(e.getMessage());
                loginModel.setPass(false);
            }
        }
        if (loginModel.isPass()) {
            this.request.getSession().invalidate();
            eruptUser = loginModel.getEruptUser();
            loginModel.setToken(Erupts.generateCode((int)16));
            loginModel.setExpire(this.eruptUserService.getExpireTime());
            loginModel.setResetPwd(null == eruptUser.getResetPwdTime());
            if (null != loginProxy) {
                loginProxy.loginSuccess(eruptUser, loginModel.getToken());
            }
            this.sessionService.put("erupt-auth:token:" + loginModel.getToken(), eruptUser.getAccount(), this.eruptUpmsProp.getExpireTimeByLogin().intValue());
            this.eruptUserService.cacheUserInfo(eruptUser, loginModel.getToken());
            this.eruptUserService.saveLoginLog(eruptUser, loginModel.getToken());
        }
        return loginModel;
    }

    @GetMapping(value={"/userinfo"})
    @EruptRouter(verifyType=EruptRouter.VerifyType.LOGIN)
    public EruptUserinfoVo userinfo() {
        EruptUser eruptUser = this.eruptUserService.getCurrentEruptUser();
        EruptUserinfoVo userinfoVo = new EruptUserinfoVo();
        userinfoVo.setNickname(eruptUser.getName());
        userinfoVo.setResetPwd(null == eruptUser.getResetPwdTime());
        Optional.ofNullable(eruptUser.getEruptMenu()).ifPresent(it -> {
            userinfoVo.setIndexMenuType(it.getType());
            userinfoVo.setIndexMenuValue(it.getValue());
        });
        return userinfoVo;
    }

    @GetMapping(value={"/menu"})
    @EruptRouter(verifyType=EruptRouter.VerifyType.LOGIN)
    public List<EruptMenuVo> getMenu() {
        List menus = (List)this.sessionService.get("erupt-auth:menu-view:" + this.eruptContextService.getCurrentToken(), new TypeToken<List<EruptMenuVo>>(){}.getType());
        menus.forEach(it -> it.setName(I18nTranslate.$translate((String)it.getName())));
        return menus;
    }

    @GetMapping(value={"/logout"})
    @EruptRouter(verifyType=EruptRouter.VerifyType.LOGIN)
    public EruptApiModel logout(HttpServletRequest request) {
        String token = this.eruptContextService.getCurrentToken();
        LoginProxy loginProxy = EruptUserService.findEruptLogin();
        Optional.ofNullable(loginProxy).ifPresent(it -> it.logout(token));
        request.getSession().invalidate();
        for (String uk : SessionKey.USER_KEY_GROUP) {
            this.sessionService.remove(uk + token);
        }
        return EruptApiModel.successApi();
    }

    @GetMapping(value={"/change-pwd"})
    @EruptRouter(verifyType=EruptRouter.VerifyType.LOGIN)
    public EruptApiModel changePwd(@RequestParam(value="pwd") String pwd, @RequestParam(value="newPwd") String newPwd, @RequestParam(value="newPwd2") String newPwd2) {
        pwd = SecretUtil.decodeSecret((String)pwd, (int)3);
        newPwd = SecretUtil.decodeSecret((String)newPwd, (int)3);
        newPwd2 = SecretUtil.decodeSecret((String)newPwd2, (int)3);
        return this.eruptUserService.changePwd(this.eruptUserService.getCurrentAccount(), pwd, newPwd, newPwd2);
    }

    @GetMapping(value={"/code-img"})
    public void createCode(HttpServletResponse response, @RequestParam long mark, @RequestParam(required=false, defaultValue="38") Integer height) throws Exception {
        response.setContentType("image/jpeg");
        response.setDateHeader("Expires", 0L);
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        SpecCaptcha captcha = new SpecCaptcha(150, height.intValue(), 4);
        this.sessionService.put("erupt-auth:verify-code:" + mark, captcha.text(), 60L, TimeUnit.SECONDS);
        captcha.out((OutputStream)response.getOutputStream());
    }
}

