/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.service;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import xyz.erupt.annotation.fun.DataProxy;
import xyz.erupt.upms.model.EruptMenu;
import xyz.erupt.upms.model.EruptRole;
import xyz.erupt.upms.model.EruptUser;
import xyz.erupt.upms.service.EruptSessionService;
import xyz.erupt.upms.service.EruptUserService;
import xyz.erupt.upms.vo.EruptMenuVo;

@Service
public class EruptMenuService
implements DataProxy<EruptMenu> {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private EruptSessionService sessionService;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private Gson gson;
    @Autowired
    private EruptUserService eruptUserService;

    public List<EruptMenu> getMenuList(EruptUser eruptUser) {
        List menus;
        if (null != eruptUser.getIsAdmin() && eruptUser.getIsAdmin().booleanValue()) {
            menus = this.entityManager.createQuery("from EruptMenu order by sort", EruptMenu.class).getResultList();
        } else {
            HashSet<EruptMenu> menuSet = new HashSet<EruptMenu>();
            for (EruptRole role : eruptUser.getRoles()) {
                if (!role.getStatus().booleanValue()) continue;
                menuSet.addAll(role.getMenus());
            }
            menus = menuSet.stream().sorted(Comparator.comparing(EruptMenu::getSort, Comparator.nullsFirst(Integer::compareTo))).collect(Collectors.toList());
        }
        return menus;
    }

    public List<EruptMenuVo> geneMenuListVo(List<EruptMenu> menus) {
        ArrayList<EruptMenuVo> list = new ArrayList<EruptMenuVo>();
        menus.forEach(menu -> {
            if (Integer.valueOf("1").equals(menu.getStatus())) {
                Long pid = null;
                if (null != menu.getParentMenu()) {
                    pid = menu.getParentMenu().getId();
                }
                list.add(new EruptMenuVo(menu.getId(), menu.getName(), menu.getType(), menu.getValue(), menu.getIcon(), pid));
            }
        });
        return list;
    }

    public void afterAdd(EruptMenu eruptMenu) {
        String token = this.request.getHeader("token");
        List<EruptMenu> eruptMenus = this.getMenuList(this.eruptUserService.getCurrentEruptUser());
        List<EruptMenuVo> menuVoList = this.geneMenuListVo(eruptMenus);
        this.sessionService.put("eruptAuth:menu:" + token, this.gson.toJson(eruptMenus));
        this.sessionService.put("eruptAuth:menu-view:" + token, this.gson.toJson(menuVoList));
    }

    public void afterUpdate(EruptMenu eruptMenu) {
        this.afterAdd(eruptMenu);
    }

    public void afterDelete(EruptMenu eruptMenu) {
        this.afterAdd(eruptMenu);
    }

    public void addBehavior(EruptMenu eruptMenu) {
        Integer obj = (Integer)this.entityManager.createQuery("select max(sort) from " + EruptMenu.class.getSimpleName()).getSingleResult();
        if (null != obj) {
            eruptMenu.setSort(obj + 10);
        }
        eruptMenu.setStatus(Integer.valueOf("1"));
    }
}

