/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.service;

import eu.bitwalker.useragentutils.UserAgent;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.Transactional;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import xyz.erupt.core.view.EruptApiModel;
import xyz.erupt.db.dao.EruptDao;
import xyz.erupt.upms.base.LoginModel;
import xyz.erupt.upms.model.EruptUser;
import xyz.erupt.upms.model.log.EruptLoginLog;
import xyz.erupt.upms.service.EruptSessionService;
import xyz.erupt.upms.util.IpUtil;
import xyz.erupt.upms.util.MD5Utils;

@Service
public class EruptUserService {
    @PersistenceContext
    private EntityManager entityManager;
    @Resource
    private EruptSessionService sessionService;
    @Resource
    private HttpServletRequest request;
    @Resource
    private EruptDao eruptDao;
    public static final String LOGIN_ERROR_HINT = "\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef";

    @Transactional
    public void saveLoginLog(EruptUser user) {
        UserAgent userAgent = UserAgent.parseUserAgentString((String)this.request.getHeader("User-Agent"));
        EruptLoginLog loginLog = new EruptLoginLog();
        loginLog.setEruptUser(user);
        loginLog.setLoginTime(new Date());
        loginLog.setIp(IpUtil.getIpAddr(this.request));
        loginLog.setSystemName(userAgent.getOperatingSystem().getName());
        loginLog.setRegion(IpUtil.getCityInfo(loginLog.getIp()));
        loginLog.setBrowser(userAgent.getBrowser().getName() + " " + (userAgent.getBrowserVersion() == null ? "" : userAgent.getBrowserVersion().getMajorVersion()));
        loginLog.setDeviceType(userAgent.getOperatingSystem().getDeviceType().getName());
        this.entityManager.persist((Object)loginLog);
    }

    public LoginModel login(String account, String pwd, String verifyCode, HttpServletRequest request) {
        EruptUser eruptUser;
        Object loginError = this.sessionService.get("eruptAuth:login-error:" + account);
        long loginErrorCount = 0L;
        if (null != loginError) {
            loginErrorCount = Long.parseLong(loginError.toString());
        }
        if (loginErrorCount >= 3L) {
            if (StringUtils.isBlank((CharSequence)verifyCode)) {
                return new LoginModel(false, "\u8bf7\u586b\u5199\u9a8c\u8bc1\u7801", true);
            }
            Object vc = this.sessionService.get("eruptAuth:verifyCode:" + account);
            this.sessionService.remove("eruptAuth:verifyCode:" + account);
            if (vc == null || !vc.toString().equalsIgnoreCase(verifyCode)) {
                return new LoginModel(false, "\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e", true);
            }
        }
        if (null != (eruptUser = this.findEruptUserByAccount(account))) {
            if (!eruptUser.getStatus().booleanValue()) {
                return new LoginModel(false, "\u8d26\u53f7\u5df2\u9501\u5b9a!");
            }
            if (StringUtils.isNotBlank((CharSequence)eruptUser.getWhiteIp())) {
                boolean isAllowIp = false;
                String ipAddr = IpUtil.getIpAddr(request);
                for (String ip : eruptUser.getWhiteIp().split("\n")) {
                    if (!ip.equals(ipAddr)) continue;
                    isAllowIp = true;
                    break;
                }
                if (!isAllowIp) {
                    return new LoginModel(false, "ip\u4e0d\u5141\u8bb8\u8bbf\u95ee");
                }
            }
            boolean pass = false;
            String digestPwd = eruptUser.getIsMd5() != false ? eruptUser.getPassword() : MD5Utils.digest(eruptUser.getPassword());
            String calcPwd = MD5Utils.digest(digestPwd + Calendar.getInstance().get(5) + account);
            if (pwd.equalsIgnoreCase(calcPwd)) {
                pass = true;
            }
            if (pass) {
                this.sessionService.put("eruptAuth:login-error:" + account, "0");
                return new LoginModel(true, eruptUser);
            }
            this.sessionService.put("eruptAuth:login-error:" + account, ++loginErrorCount + "");
            if (loginErrorCount >= 3L) {
                return new LoginModel(false, LOGIN_ERROR_HINT, true);
            }
            return new LoginModel(false, LOGIN_ERROR_HINT);
        }
        return new LoginModel(false, LOGIN_ERROR_HINT);
    }

    @Transactional
    public EruptApiModel changePwd(String account, String pwd, String newPwd, String newPwd2) {
        if (!newPwd.equals(newPwd2)) {
            return EruptApiModel.errorNoInterceptApi((String)"\u4fee\u6539\u5931\u8d25\uff0c\u65b0\u5bc6\u7801\u4e0e\u786e\u8ba4\u5bc6\u7801\u4e0d\u5339\u914d");
        }
        EruptUser eruptUser = this.findEruptUserByAccount(account);
        if (eruptUser.getIsMd5().booleanValue()) {
            pwd = MD5Utils.digest(pwd);
            newPwd = MD5Utils.digest(newPwd);
        }
        if (eruptUser.getPassword().equals(pwd)) {
            if (newPwd.equals(eruptUser.getPassword())) {
                return EruptApiModel.errorNoInterceptApi((String)"\u4fee\u6539\u5931\u8d25\uff0c\u65b0\u5bc6\u7801\u4e0d\u80fd\u548c\u539f\u59cb\u5bc6\u7801\u4e00\u6837");
            }
            eruptUser.setPassword(newPwd);
            this.entityManager.merge((Object)eruptUser);
            return EruptApiModel.successApi();
        }
        return EruptApiModel.errorNoInterceptApi((String)"\u5bc6\u7801\u9519\u8bef");
    }

    public void createToken(LoginModel loginModel) {
        loginModel.setToken(RandomStringUtils.random((int)20, (boolean)true, (boolean)true));
        this.sessionService.put("eruptAuth:token:" + loginModel.getToken(), loginModel.getEruptUser().getId().toString());
    }

    public EruptUser getCurrentEruptUser() {
        this.entityManager.clear();
        Long uid = this.getCurrentUid();
        return null == uid ? null : (EruptUser)((Object)this.entityManager.find(EruptUser.class, (Object)uid));
    }

    public Long getCurrentUid() {
        Object uid;
        String token = this.request.getHeader("token");
        if (StringUtils.isBlank((CharSequence)token)) {
            token = this.request.getParameter("_token");
        }
        return null == (uid = this.sessionService.get("eruptAuth:token:" + token)) ? null : Long.valueOf(uid.toString());
    }

    private EruptUser findEruptUserByAccount(final String account) {
        return (EruptUser)((Object)this.eruptDao.queryEntity(EruptUser.class, "account = :account", (Map)new HashMap<String, Object>(1){
            {
                super(x0);
                this.put("account", account);
            }
        }));
    }
}

