/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.controller;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.wf.captcha.ArithmeticCaptcha;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import xyz.erupt.core.annotation.EruptRouter;
import xyz.erupt.core.view.EruptApiModel;
import xyz.erupt.upms.base.LoginModel;
import xyz.erupt.upms.model.EruptMenu;
import xyz.erupt.upms.model.EruptUser;
import xyz.erupt.upms.service.EruptMenuService;
import xyz.erupt.upms.service.EruptSessionService;
import xyz.erupt.upms.service.EruptUserService;
import xyz.erupt.upms.vo.EruptMenuVo;

@RestController
@RequestMapping(value={"/erupt-api"})
public class EruptUserController {
    @Autowired
    private EruptMenuService menuService;
    @Autowired
    private EruptUserService eruptUserService;
    @Autowired
    private EruptSessionService sessionService;
    @Autowired
    private Gson gson;

    @PostMapping(value={"/login"})
    @ResponseBody
    public LoginModel login(@RequestParam(value="account") String account, @RequestParam(value="pwd") String pwd, @RequestParam(name="verifyCode", required=false) String verifyCode, HttpServletRequest request) {
        LoginModel loginModel = this.eruptUserService.login(account, pwd, verifyCode, request);
        if (loginModel.isPass()) {
            EruptUser eruptUser = loginModel.getEruptUser();
            this.eruptUserService.createToken(loginModel);
            loginModel.setUserName(eruptUser.getName());
            EruptMenu indexMenu = eruptUser.getEruptMenu();
            if (null != indexMenu) {
                loginModel.setIndexMenu(indexMenu.getType() + "||" + indexMenu.getValue());
            }
            List<EruptMenu> eruptMenus = this.menuService.getMenuList(eruptUser);
            this.sessionService.put("eruptAuth:menu:" + loginModel.getToken(), this.gson.toJson(eruptMenus));
            this.sessionService.put("eruptAuth:menu-view:" + loginModel.getToken(), this.gson.toJson(this.menuService.geneMenuListVo(eruptMenus)));
            this.eruptUserService.saveLoginLog(eruptUser);
        }
        return loginModel;
    }

    @GetMapping(value={"/menu"})
    @ResponseBody
    @EruptRouter(verifyType=EruptRouter.VerifyType.LOGIN, authIndex=0)
    public List<EruptMenuVo> getMenu() {
        return (List)this.sessionService.get("eruptAuth:menu-view:" + this.eruptUserService.getToken(), new TypeToken<List<EruptMenuVo>>(){}.getType());
    }

    @PostMapping(value={"/logout"})
    @ResponseBody
    @EruptRouter(verifyType=EruptRouter.VerifyType.LOGIN, authIndex=0)
    public EruptApiModel logout(HttpServletRequest request) {
        String token = request.getHeader("token");
        this.sessionService.remove("eruptAuth:menu:" + token);
        this.sessionService.remove("eruptAuth:menu-view:" + token);
        this.sessionService.remove("eruptAuth:token:" + token);
        return EruptApiModel.successApi();
    }

    @PostMapping(value={"/change-pwd"})
    @ResponseBody
    @EruptRouter(verifyType=EruptRouter.VerifyType.LOGIN, authIndex=0)
    public EruptApiModel changePwd(@RequestParam(value="account") String account, @RequestParam(value="pwd") String pwd, @RequestParam(value="newPwd") String newPwd, @RequestParam(value="newPwd2") String newPwd2) {
        return this.eruptUserService.changePwd(account, pwd, newPwd, newPwd2);
    }

    @GetMapping
    @RequestMapping(value={"/code-img"})
    public void createCode(@RequestParam(value="account") String account, HttpServletResponse response) throws Exception {
        response.setContentType("image/jpeg");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        ArithmeticCaptcha captcha = new ArithmeticCaptcha(150, 38, 3);
        this.sessionService.put("eruptAuth:verifyCode:" + account, captcha.text(), 60L);
        captcha.out((OutputStream)response.getOutputStream());
    }
}

