/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.service;

import com.google.gson.Gson;
import eu.bitwalker.useragentutils.UserAgent;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import xyz.erupt.core.config.EruptAppProp;
import xyz.erupt.core.config.EruptProp;
import xyz.erupt.core.config.GsonFactory;
import xyz.erupt.core.service.EruptApplication;
import xyz.erupt.core.util.EruptSpringUtil;
import xyz.erupt.core.view.EruptApiModel;
import xyz.erupt.jpa.dao.EruptDao;
import xyz.erupt.upms.base.LoginModel;
import xyz.erupt.upms.cache.CaffeineEruptCache;
import xyz.erupt.upms.cache.IEruptCache;
import xyz.erupt.upms.config.EruptUpmsConfig;
import xyz.erupt.upms.fun.EruptLogin;
import xyz.erupt.upms.fun.LoginProxy;
import xyz.erupt.upms.model.EruptMenu;
import xyz.erupt.upms.model.EruptRole;
import xyz.erupt.upms.model.EruptUser;
import xyz.erupt.upms.model.log.EruptLoginLog;
import xyz.erupt.upms.service.EruptMenuService;
import xyz.erupt.upms.service.EruptSessionService;
import xyz.erupt.upms.util.IpUtil;
import xyz.erupt.upms.util.MD5Utils;

@Service
public class EruptUserService {
    @PersistenceContext
    private EntityManager entityManager;
    @Resource
    private EruptSessionService sessionService;
    @Resource
    private HttpServletRequest request;
    @Resource
    private EruptDao eruptDao;
    @Resource
    private EruptAppProp eruptAppProp;
    @Resource
    private EruptProp eruptProp;
    @Resource
    private EruptUpmsConfig eruptUpmsConfig;
    @Resource
    private EruptMenuService eruptMenuService;
    private final Gson gson = GsonFactory.getGson();
    public static final String LOGIN_ERROR_HINT = "\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef";
    private final IEruptCache<EruptUser> eruptUserIEruptCache = new CaffeineEruptCache<EruptUser>(1500L);

    public void cacheUserInfo(EruptUser eruptUser, String token) {
        List<EruptMenu> eruptMenus = this.eruptMenuService.getUserAllMenu(eruptUser);
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        HashMap<String, Object> codeMap = new HashMap<String, Object>();
        for (EruptMenu menu : eruptMenus) {
            codeMap.put(menu.getCode(), (Object)menu);
            if (null == menu.getValue()) continue;
            valueMap.put(menu.getValue(), (Object)menu);
        }
        StringBuilder sb = new StringBuilder();
        for (EruptRole role : eruptUser.getRoles()) {
            sb.append(role.getPowerOff()).append("|");
        }
        this.sessionService.putMap("eruptAuth:menu-value-map:" + token, valueMap, this.eruptUpmsConfig.getExpireTimeByLogin().intValue());
        this.sessionService.putMap("eruptAuth:menu-code-map:" + token, codeMap, this.eruptUpmsConfig.getExpireTimeByLogin().intValue());
        this.sessionService.put("eruptAuth:menu-view:" + token, this.gson.toJson(this.eruptMenuService.geneMenuListVo(eruptMenus)), this.eruptUpmsConfig.getExpireTimeByLogin().intValue());
        this.sessionService.put("eruptAuth:role-power:" + token, sb.toString(), this.eruptUpmsConfig.getExpireTimeByLogin().intValue());
    }

    public static LoginProxy findEruptLogin() {
        EruptLogin eruptLogin = EruptApplication.getPrimarySource().getAnnotation(EruptLogin.class);
        if (null != eruptLogin) {
            return (LoginProxy)EruptSpringUtil.getBean(eruptLogin.value());
        }
        return null;
    }

    private boolean loginErrorCountPlus(String ip) {
        Object loginError = this.sessionService.get("eruptAuth:login-error:" + ip);
        int loginErrorCount = 0;
        if (null != loginError) {
            loginErrorCount = Integer.parseInt(loginError.toString());
        }
        this.sessionService.put("eruptAuth:login-error:" + ip, ++loginErrorCount + "", this.eruptUpmsConfig.getExpireTimeByLogin().intValue());
        return loginErrorCount >= this.eruptAppProp.getVerifyCodeCount();
    }

    public LoginModel login(String account, String pwd) {
        String requestIp = IpUtil.getIpAddr(this.request);
        EruptUser eruptUser = this.findEruptUserByAccount(account);
        if (null != eruptUser) {
            if (!eruptUser.getStatus().booleanValue()) {
                return new LoginModel(false, "\u8d26\u53f7\u5df2\u9501\u5b9a!");
            }
            if (StringUtils.isNotBlank((CharSequence)eruptUser.getWhiteIp())) {
                boolean isAllowIp = false;
                for (String ip : eruptUser.getWhiteIp().split("\n")) {
                    if (!ip.equals(requestIp)) continue;
                    isAllowIp = true;
                    break;
                }
                if (!isAllowIp) {
                    return new LoginModel(false, "ip\u4e0d\u5141\u8bb8\u8bbf\u95ee");
                }
            }
            if (this.checkPwd(eruptUser, pwd)) {
                this.sessionService.put("eruptAuth:login-error:" + requestIp, "0", this.eruptUpmsConfig.getExpireTimeByLogin().intValue());
                return new LoginModel(true, eruptUser);
            }
            return new LoginModel(false, LOGIN_ERROR_HINT, this.loginErrorCountPlus(requestIp));
        }
        return new LoginModel(false, LOGIN_ERROR_HINT, this.loginErrorCountPlus(requestIp));
    }

    public boolean checkPwd(EruptUser eruptUser, String pwd) {
        if (this.eruptAppProp.getPwdTransferEncrypt().booleanValue()) {
            String digestPwd = eruptUser.getIsMd5() != false ? eruptUser.getPassword() : MD5Utils.digest(eruptUser.getPassword());
            String calcPwd = MD5Utils.digest(digestPwd + Calendar.getInstance().get(5) + eruptUser.getAccount());
            return pwd.equalsIgnoreCase(calcPwd);
        }
        if (eruptUser.getIsMd5().booleanValue()) {
            pwd = MD5Utils.digest(pwd);
        }
        return pwd.equals(eruptUser.getPassword());
    }

    public LocalDateTime getExpireTime() {
        if (this.eruptProp.isRedisSession()) {
            return LocalDateTime.now().plusMinutes(this.eruptUpmsConfig.getExpireTimeByLogin().intValue());
        }
        return LocalDateTime.now().plusSeconds(this.request.getSession().getMaxInactiveInterval());
    }

    public boolean checkVerifyCode(String verifyCode) {
        String requestIp = IpUtil.getIpAddr(this.request);
        Object loginError = this.sessionService.get("eruptAuth:login-error:" + requestIp);
        long loginErrorCount = 0L;
        if (null != loginError) {
            loginErrorCount = Long.parseLong(loginError.toString());
        }
        if (loginErrorCount >= (long)this.eruptAppProp.getVerifyCodeCount().intValue()) {
            if (StringUtils.isBlank((CharSequence)verifyCode)) {
                return false;
            }
            Object vc = this.sessionService.get("eruptAuth:verifyCode:" + requestIp);
            this.sessionService.remove("eruptAuth:verifyCode:" + requestIp);
            return vc != null && vc.toString().equalsIgnoreCase(verifyCode);
        }
        return true;
    }

    @Transactional
    public void saveLoginLog(EruptUser user, String token) {
        UserAgent userAgent = UserAgent.parseUserAgentString((String)this.request.getHeader("User-Agent"));
        EruptLoginLog loginLog = new EruptLoginLog();
        loginLog.setToken(token);
        loginLog.setEruptUser(user);
        loginLog.setLoginTime(new Date());
        loginLog.setIp(IpUtil.getIpAddr(this.request));
        loginLog.setSystemName(userAgent.getOperatingSystem().getName());
        loginLog.setRegion(IpUtil.getCityInfo(loginLog.getIp()));
        loginLog.setBrowser(userAgent.getBrowser().getName() + " " + (userAgent.getBrowserVersion() == null ? "" : userAgent.getBrowserVersion().getMajorVersion()));
        loginLog.setDeviceType(userAgent.getOperatingSystem().getDeviceType().getName());
        this.entityManager.persist((Object)loginLog);
    }

    @Transactional
    public EruptApiModel changePwd(String account, String pwd, String newPwd, String newPwd2) {
        if (!newPwd.equals(newPwd2)) {
            return EruptApiModel.errorNoInterceptApi((String)"\u4fee\u6539\u5931\u8d25\uff0c\u65b0\u5bc6\u7801\u4e0e\u786e\u8ba4\u5bc6\u7801\u4e0d\u5339\u914d");
        }
        EruptUser eruptUser = this.findEruptUserByAccount(account);
        LoginProxy loginProxy = EruptUserService.findEruptLogin();
        if (null != loginProxy) {
            loginProxy.beforeChangePwd(eruptUser, newPwd);
        }
        if (eruptUser.getIsMd5().booleanValue()) {
            pwd = MD5Utils.digest(pwd);
            newPwd = MD5Utils.digest(newPwd);
        }
        if (eruptUser.getPassword().equals(pwd)) {
            if (newPwd.equals(eruptUser.getPassword())) {
                return EruptApiModel.errorNoInterceptApi((String)"\u4fee\u6539\u5931\u8d25\uff0c\u65b0\u5bc6\u7801\u4e0d\u80fd\u548c\u539f\u59cb\u5bc6\u7801\u4e00\u6837");
            }
            eruptUser.setPassword(newPwd);
            this.entityManager.merge((Object)eruptUser);
            return EruptApiModel.successApi();
        }
        return EruptApiModel.errorNoInterceptApi((String)"\u5bc6\u7801\u9519\u8bef");
    }

    private EruptUser findEruptUserByAccount(final String account) {
        return (EruptUser)((Object)this.eruptDao.queryEntity(EruptUser.class, "account = :account", (Map)new HashMap<String, Object>(1){
            {
                super(initialCapacity);
                this.put("account", account);
            }
        }));
    }

    public EruptMenu getEruptMenuByCode(String menuValue) {
        return this.sessionService.getMapValue("eruptAuth:menu-code-map:" + this.getCurrentToken(), menuValue, EruptMenu.class);
    }

    public EruptMenu getEruptMenuByValue(String menuValue) {
        return this.sessionService.getMapValue("eruptAuth:menu-value-map:" + this.getCurrentToken(), menuValue, EruptMenu.class);
    }

    public String getCurrentToken() {
        String token = this.request.getHeader("token");
        if (StringUtils.isBlank((CharSequence)token)) {
            token = this.request.getParameter("_token");
        }
        return token;
    }

    public EruptMenu getCurrentEruptMenu() {
        String erupt = this.request.getHeader("erupt");
        if (StringUtils.isBlank((CharSequence)erupt)) {
            erupt = this.request.getParameter("_erupt");
        }
        Assert.notNull((Object)erupt, (String)"request header 'erupt' not found ");
        return this.sessionService.getMapValue("eruptAuth:menu-value-map:" + this.getCurrentToken(), erupt, EruptMenu.class);
    }

    public Long getCurrentUid() {
        Object uid = this.sessionService.get("eruptAuth:token:" + this.getCurrentToken());
        return null == uid ? null : Long.valueOf(uid.toString());
    }

    public EruptUser getCurrentEruptUser() {
        this.entityManager.clear();
        Long uid = this.getCurrentUid();
        return null == uid ? null : this.eruptUserIEruptCache.get(uid + "", key -> (EruptUser)((Object)((Object)this.entityManager.find(EruptUser.class, (Object)Long.parseLong(key)))));
    }
}

