/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.looker;

import java.util.Date;
import javax.annotation.Resource;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.springframework.stereotype.Service;
import xyz.erupt.annotation.EruptField;
import xyz.erupt.annotation.PreDataProxy;
import xyz.erupt.annotation.config.SkipSerialize;
import xyz.erupt.annotation.fun.DataProxy;
import xyz.erupt.annotation.sub_field.Edit;
import xyz.erupt.annotation.sub_field.EditType;
import xyz.erupt.annotation.sub_field.View;
import xyz.erupt.annotation.sub_field.sub_edit.DateType;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.jpa.model.BaseModel;
import xyz.erupt.upms.model.EruptUser;
import xyz.erupt.upms.service.EruptUserService;

@MappedSuperclass
@PreDataProxy(value=LookerPostLevel.class)
@Service
public class LookerPostLevel
extends BaseModel
implements DataProxy<LookerPostLevel> {
    @ManyToOne
    @EruptField(views={@View(title="\u521b\u5efa\u4eba", column="name"), @View(title="\u6240\u5c5e\u7ec4\u7ec7", column="eruptOrg.name"), @View(title="\u5c97\u4f4d", column="eruptPost.name")}, edit=@Edit(title="\u521b\u5efa\u4eba", readOnly=true, type=EditType.REFERENCE_TABLE))
    private EruptUser createUser;
    @EruptField(views={@View(title="\u521b\u5efa\u65f6\u95f4")}, edit=@Edit(title="\u521b\u5efa\u65f6\u95f4", readOnly=true, dateType=@DateType(type=DateType.Type.DATE_TIME)))
    private Date createTime;
    @SkipSerialize
    private Date updateTime;
    @ManyToOne
    @SkipSerialize
    private EruptUser updateUser;
    @Resource
    @Transient
    private EruptUserService eruptUserService;

    public String beforeFetch() {
        EruptUser eruptUser = this.eruptUserService.getCurrentEruptUser();
        if (eruptUser.getIsAdmin().booleanValue()) {
            return null;
        }
        if (null == eruptUser.getEruptOrg() || null == eruptUser.getEruptPost()) {
            throw new EruptWebApiRuntimeException(eruptUser.getName() + " unbounded department cannot filter data");
        }
        String erupt = this.eruptUserService.getCurrentEruptMenu().getValue();
        return "(" + erupt + ".createUser.id = " + this.eruptUserService.getCurrentUid() + " or " + erupt + ".createUser.eruptOrg.id = " + eruptUser.getEruptOrg().getId() + " and " + erupt + ".createUser.eruptPost.weight < " + eruptUser.getEruptPost().getWeight() + ")";
    }

    public void beforeAdd(LookerPostLevel lookerPostLevel) {
        lookerPostLevel.setCreateTime(new Date());
        lookerPostLevel.setCreateUser(new EruptUser(this.eruptUserService.getCurrentUid()));
    }

    public void beforeUpdate(LookerPostLevel lookerPostLevel) {
        lookerPostLevel.setUpdateTime(new Date());
        lookerPostLevel.setUpdateUser(new EruptUser(this.eruptUserService.getCurrentUid()));
    }

    public EruptUser getCreateUser() {
        return this.createUser;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public EruptUser getUpdateUser() {
        return this.updateUser;
    }

    public EruptUserService getEruptUserService() {
        return this.eruptUserService;
    }

    public void setCreateUser(EruptUser createUser) {
        this.createUser = createUser;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public void setUpdateUser(EruptUser updateUser) {
        this.updateUser = updateUser;
    }

    public void setEruptUserService(EruptUserService eruptUserService) {
        this.eruptUserService = eruptUserService;
    }
}

