/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.controller;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.wf.captcha.ArithmeticCaptcha;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import xyz.erupt.core.annotation.EruptRouter;
import xyz.erupt.core.view.EruptApiModel;
import xyz.erupt.upms.base.LoginModel;
import xyz.erupt.upms.model.EruptMenu;
import xyz.erupt.upms.model.EruptUser;
import xyz.erupt.upms.service.EruptMenuService;
import xyz.erupt.upms.service.EruptSessionService;
import xyz.erupt.upms.service.EruptUserService;
import xyz.erupt.upms.util.IpUtil;
import xyz.erupt.upms.vo.EruptMenuVo;

@RestController
@RequestMapping(value={"/erupt-api"})
public class EruptUserController {
    @Resource
    private EruptMenuService menuService;
    @Resource
    private EruptUserService eruptUserService;
    @Resource
    private EruptSessionService sessionService;
    @Resource
    private Gson gson;

    @PostMapping(value={"/login"})
    @ResponseBody
    public LoginModel login(@RequestParam(value="account") String account, @RequestParam(value="pwd") String pwd, @RequestParam(name="verifyCode", required=false) String verifyCode, HttpServletRequest request) {
        LoginModel loginModel = this.eruptUserService.login(account, pwd, verifyCode);
        if (loginModel.isPass()) {
            EruptUser eruptUser = loginModel.getEruptUser();
            loginModel.setToken(RandomStringUtils.random((int)20, (boolean)true, (boolean)true));
            loginModel.setExpire(this.eruptUserService.getExpireTime());
            this.sessionService.putByLoginExpire("eruptAuth:token:" + loginModel.getToken(), loginModel.getEruptUser().getId().toString());
            loginModel.setUserName(eruptUser.getName());
            EruptMenu indexMenu = eruptUser.getEruptMenu();
            if (null != indexMenu) {
                loginModel.setIndexMenu(indexMenu.getType() + "||" + indexMenu.getValue());
            }
            List<EruptMenu> eruptMenus = this.menuService.getMenuList(eruptUser);
            this.sessionService.putByLoginExpire("eruptAuth:menu:" + loginModel.getToken(), this.gson.toJson(eruptMenus));
            this.sessionService.putByLoginExpire("eruptAuth:menu-view:" + loginModel.getToken(), this.gson.toJson(this.menuService.geneMenuListVo(eruptMenus)));
            this.eruptUserService.saveLoginLog(eruptUser);
        }
        return loginModel;
    }

    @GetMapping(value={"/token-valid"})
    @ResponseBody
    public boolean tokenValid() {
        return this.sessionService.get(this.eruptUserService.getToken()) != null;
    }

    @GetMapping(value={"/menu"})
    @ResponseBody
    @EruptRouter(verifyType=EruptRouter.VerifyType.LOGIN, authIndex=0)
    public List<EruptMenuVo> getMenu() {
        return (List)this.sessionService.get("eruptAuth:menu-view:" + this.eruptUserService.getToken(), new TypeToken<List<EruptMenuVo>>(){}.getType());
    }

    @PostMapping(value={"/logout"})
    @ResponseBody
    @EruptRouter(verifyType=EruptRouter.VerifyType.LOGIN, authIndex=0)
    public EruptApiModel logout(HttpServletRequest request) {
        String token = request.getHeader("token");
        this.sessionService.remove("eruptAuth:menu:" + token);
        this.sessionService.remove("eruptAuth:menu-view:" + token);
        this.sessionService.remove("eruptAuth:token:" + token);
        return EruptApiModel.successApi();
    }

    @PostMapping(value={"/change-pwd"})
    @ResponseBody
    @EruptRouter(verifyType=EruptRouter.VerifyType.LOGIN, authIndex=0)
    public EruptApiModel changePwd(@RequestParam(value="account") String account, @RequestParam(value="pwd") String pwd, @RequestParam(value="newPwd") String newPwd, @RequestParam(value="newPwd2") String newPwd2) {
        return this.eruptUserService.changePwd(account, pwd, newPwd, newPwd2);
    }

    @GetMapping
    @RequestMapping(value={"/code-img"})
    public void createCode(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("image/jpeg");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        ArithmeticCaptcha captcha = new ArithmeticCaptcha(150, 38, 2);
        this.sessionService.put("eruptAuth:verifyCode:" + IpUtil.getIpAddr(request), captcha.text(), 60L);
        captcha.out((OutputStream)response.getOutputStream());
    }
}

