/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.service;

import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import xyz.erupt.core.config.EruptProp;
import xyz.erupt.upms.config.EruptUpmsConfig;

@Component
public class EruptSessionService {
    @Autowired
    private EruptProp eruptProp;
    @Autowired
    private EruptUpmsConfig eruptUpmsConfig;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Resource
    private HttpServletRequest request;
    @Autowired
    private Gson gson;

    public void put(String key, String str, long timeout) {
        if (this.eruptProp.isRedisSession()) {
            this.redisTemplate.opsForValue().set((Object)key, (Object)str, timeout, TimeUnit.SECONDS);
        } else {
            this.request.getSession().setAttribute(key, (Object)str);
        }
    }

    public void putByLoginExpire(String key, String str) {
        if (this.eruptProp.isRedisSession()) {
            this.redisTemplate.opsForValue().set((Object)key, (Object)str, (long)this.eruptUpmsConfig.getExpireTimeByLogin().intValue(), TimeUnit.MINUTES);
        } else {
            this.request.getSession().setAttribute(key, (Object)str);
        }
    }

    public void remove(String key) {
        if (this.eruptProp.isRedisSession()) {
            this.redisTemplate.delete((Object)key);
        } else {
            this.request.getSession().removeAttribute(key);
        }
    }

    public Object get(String key) {
        if (this.eruptProp.isRedisSession()) {
            return this.redisTemplate.opsForValue().get((Object)key);
        }
        return this.request.getSession().getAttribute(key);
    }

    public <T> T get(String key, Type type) {
        if (this.eruptProp.isRedisSession()) {
            if (null == this.get(key)) {
                return null;
            }
            return (T)this.gson.fromJson(this.get(key).toString(), type);
        }
        return (T)this.gson.fromJson(this.request.getSession().getAttribute(key).toString(), type);
    }
}

