/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.service;

import com.google.gson.reflect.TypeToken;
import eu.bitwalker.useragentutils.UserAgent;
import java.time.LocalDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.http.HttpServletRequest;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import xyz.erupt.core.config.EruptAppProp;
import xyz.erupt.core.config.EruptProp;
import xyz.erupt.core.view.EruptApiModel;
import xyz.erupt.jpa.dao.EruptDao;
import xyz.erupt.upms.base.LoginModel;
import xyz.erupt.upms.config.EruptUpmsConfig;
import xyz.erupt.upms.model.EruptMenu;
import xyz.erupt.upms.model.EruptUser;
import xyz.erupt.upms.model.log.EruptLoginLog;
import xyz.erupt.upms.service.EruptSessionService;
import xyz.erupt.upms.util.IpUtil;
import xyz.erupt.upms.util.MD5Utils;

@Service
public class EruptUserService {
    @PersistenceContext
    private EntityManager entityManager;
    @Resource
    private EruptSessionService sessionService;
    @Resource
    private HttpServletRequest request;
    @Resource
    private EruptDao eruptDao;
    @Resource
    private EruptAppProp eruptAppProp;
    @Resource
    private EruptProp eruptProp;
    @Resource
    private EruptUpmsConfig eruptUpmsConfig;
    public static final String LOGIN_ERROR_HINT = "\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef";

    @Transactional
    public void saveLoginLog(EruptUser user) {
        UserAgent userAgent = UserAgent.parseUserAgentString((String)this.request.getHeader("User-Agent"));
        EruptLoginLog loginLog = new EruptLoginLog();
        loginLog.setEruptUser(user);
        loginLog.setLoginTime(new Date());
        loginLog.setIp(IpUtil.getIpAddr(this.request));
        loginLog.setSystemName(userAgent.getOperatingSystem().getName());
        loginLog.setRegion(IpUtil.getCityInfo(loginLog.getIp()));
        loginLog.setBrowser(userAgent.getBrowser().getName() + " " + (userAgent.getBrowserVersion() == null ? "" : userAgent.getBrowserVersion().getMajorVersion()));
        loginLog.setDeviceType(userAgent.getOperatingSystem().getDeviceType().getName());
        this.entityManager.persist((Object)loginLog);
    }

    public LoginModel login(String account, String pwd, String verifyCode) {
        EruptUser eruptUser;
        String requestIp = IpUtil.getIpAddr(this.request);
        Object loginError = this.sessionService.get("eruptAuth:login-error:" + requestIp);
        long loginErrorCount = 0L;
        if (null != loginError) {
            loginErrorCount = Long.parseLong(loginError.toString());
        }
        if (loginErrorCount >= (long)this.eruptAppProp.getVerifyCodeCount().intValue()) {
            if (StringUtils.isBlank((CharSequence)verifyCode)) {
                return new LoginModel(false, "\u8bf7\u586b\u5199\u9a8c\u8bc1\u7801", true);
            }
            Object vc = this.sessionService.get("eruptAuth:verifyCode:" + requestIp);
            this.sessionService.remove("eruptAuth:verifyCode:" + requestIp);
            if (vc == null || !vc.toString().equalsIgnoreCase(verifyCode)) {
                return new LoginModel(false, "\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e", true);
            }
        }
        if (null != (eruptUser = this.findEruptUserByAccount(account))) {
            if (!eruptUser.getStatus().booleanValue()) {
                return new LoginModel(false, "\u8d26\u53f7\u5df2\u9501\u5b9a!");
            }
            if (StringUtils.isNotBlank((CharSequence)eruptUser.getWhiteIp())) {
                boolean isAllowIp = false;
                for (String ip : eruptUser.getWhiteIp().split("\n")) {
                    if (!ip.equals(requestIp)) continue;
                    isAllowIp = true;
                    break;
                }
                if (!isAllowIp) {
                    return new LoginModel(false, "ip\u4e0d\u5141\u8bb8\u8bbf\u95ee");
                }
            }
            boolean pass = false;
            String digestPwd = eruptUser.getIsMd5() != false ? eruptUser.getPassword() : MD5Utils.digest(eruptUser.getPassword());
            String calcPwd = MD5Utils.digest(digestPwd + Calendar.getInstance().get(5) + account);
            if (pwd.equalsIgnoreCase(calcPwd)) {
                pass = true;
            }
            if (pass) {
                this.sessionService.putByLoginExpire("eruptAuth:login-error:" + requestIp, "0");
                return new LoginModel(true, eruptUser);
            }
            return new LoginModel(false, LOGIN_ERROR_HINT, this.loginErrorCountPlus(requestIp));
        }
        return new LoginModel(false, LOGIN_ERROR_HINT, this.loginErrorCountPlus(requestIp));
    }

    private boolean loginErrorCountPlus(String ip) {
        Object loginError = this.sessionService.get("eruptAuth:login-error:" + ip);
        int loginErrorCount = 0;
        if (null != loginError) {
            loginErrorCount = Integer.parseInt(loginError.toString());
        }
        this.sessionService.putByLoginExpire("eruptAuth:login-error:" + ip, ++loginErrorCount + "");
        return loginErrorCount >= this.eruptAppProp.getVerifyCodeCount();
    }

    public LocalDateTime getExpireTime() {
        if (this.eruptProp.isRedisSession()) {
            return LocalDateTime.now().plusMinutes(this.eruptUpmsConfig.getExpireTimeByLogin().intValue());
        }
        return LocalDateTime.now().plusSeconds(this.request.getSession().getMaxInactiveInterval());
    }

    @Transactional
    public EruptApiModel changePwd(String account, String pwd, String newPwd, String newPwd2) {
        if (!newPwd.equals(newPwd2)) {
            return EruptApiModel.errorNoInterceptApi((String)"\u4fee\u6539\u5931\u8d25\uff0c\u65b0\u5bc6\u7801\u4e0e\u786e\u8ba4\u5bc6\u7801\u4e0d\u5339\u914d");
        }
        EruptUser eruptUser = this.findEruptUserByAccount(account);
        if (eruptUser.getIsMd5().booleanValue()) {
            pwd = MD5Utils.digest(pwd);
            newPwd = MD5Utils.digest(newPwd);
        }
        if (eruptUser.getPassword().equals(pwd)) {
            if (newPwd.equals(eruptUser.getPassword())) {
                return EruptApiModel.errorNoInterceptApi((String)"\u4fee\u6539\u5931\u8d25\uff0c\u65b0\u5bc6\u7801\u4e0d\u80fd\u548c\u539f\u59cb\u5bc6\u7801\u4e00\u6837");
            }
            eruptUser.setPassword(newPwd);
            this.entityManager.merge((Object)eruptUser);
            return EruptApiModel.successApi();
        }
        return EruptApiModel.errorNoInterceptApi((String)"\u5bc6\u7801\u9519\u8bef");
    }

    public EruptUser getCurrentEruptUser() {
        this.entityManager.clear();
        Long uid = this.getCurrentUid();
        return null == uid ? null : (EruptUser)((Object)this.entityManager.find(EruptUser.class, (Object)uid));
    }

    public List<EruptMenu> getCurrentEruptUserMenu() {
        return (List)this.sessionService.get("eruptAuth:menu:" + this.getToken(), new TypeToken<List<EruptMenu>>(){}.getType());
    }

    public String getToken() {
        String token = this.request.getHeader("token");
        if (StringUtils.isBlank((CharSequence)token)) {
            token = this.request.getParameter("_token");
        }
        return token;
    }

    public Long getCurrentUid() {
        Object uid = this.sessionService.get("eruptAuth:token:" + this.getToken());
        return null == uid ? null : Long.valueOf(uid.toString());
    }

    private EruptUser findEruptUserByAccount(final String account) {
        return (EruptUser)((Object)this.eruptDao.queryEntity(EruptUser.class, "account = :account", (Map)new HashMap<String, Object>(1){
            {
                super(x0);
                this.put("account", account);
            }
        }));
    }
}

