/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.controller;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.wf.captcha.SpecCaptcha;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import xyz.erupt.core.annotation.EruptRouter;
import xyz.erupt.core.config.EruptAppProp;
import xyz.erupt.core.config.GsonFactory;
import xyz.erupt.core.view.EruptApiModel;
import xyz.erupt.upms.base.LoginModel;
import xyz.erupt.upms.fun.LoginProxy;
import xyz.erupt.upms.model.EruptMenu;
import xyz.erupt.upms.model.EruptUser;
import xyz.erupt.upms.service.EruptMenuService;
import xyz.erupt.upms.service.EruptSessionService;
import xyz.erupt.upms.service.EruptUserService;
import xyz.erupt.upms.util.IpUtil;
import xyz.erupt.upms.vo.EruptMenuVo;

@RestController
@RequestMapping(value={"/erupt-api"})
public class EruptUserController {
    @Resource
    private EruptMenuService menuService;
    @Resource
    private EruptUserService eruptUserService;
    @Resource
    private EruptSessionService sessionService;
    @Resource
    private EruptAppProp eruptAppProp;
    private final Gson gson = GsonFactory.getGson();

    @PostMapping(value={"/login"})
    @ResponseBody
    public LoginModel login(@RequestParam(value="account") String account, @RequestParam(value="pwd") String pwd, @RequestParam(name="verifyCode", required=false) String verifyCode) {
        EruptUser eruptUser;
        LoginModel loginModel;
        if (!this.eruptUserService.checkVerifyCode(verifyCode)) {
            LoginModel loginModel2 = new LoginModel();
            loginModel2.setUseVerifyCode(true);
            loginModel2.setReason("\u9a8c\u8bc1\u7801\u9519\u8bef");
            loginModel2.setPass(false);
            return loginModel2;
        }
        LoginProxy loginProxy = EruptUserService.findEruptLogin();
        if (null == loginProxy) {
            loginModel = this.eruptUserService.login(account, pwd);
        } else {
            loginModel = new LoginModel();
            try {
                eruptUser = loginProxy.login(account, pwd);
                loginModel.setEruptUser(eruptUser);
                loginModel.setPass(true);
            }
            catch (Exception e) {
                if (0 == this.eruptAppProp.getVerifyCodeCount()) {
                    loginModel.setUseVerifyCode(true);
                }
                loginModel.setReason(e.getMessage());
                loginModel.setPass(false);
            }
        }
        if (loginModel.isPass()) {
            eruptUser = loginModel.getEruptUser();
            loginModel.setToken(RandomStringUtils.random((int)16, (boolean)true, (boolean)true));
            loginModel.setExpire(this.eruptUserService.getExpireTime());
            this.sessionService.putByLoginExpire("eruptAuth:token:" + loginModel.getToken(), loginModel.getEruptUser().getId().toString());
            List<EruptMenu> eruptMenus = this.menuService.getMenuList(eruptUser);
            if (null != loginProxy) {
                loginProxy.loginSuccess(eruptUser, loginModel.getToken());
            }
            this.sessionService.putByLoginExpire("eruptAuth:menu:" + loginModel.getToken(), this.gson.toJson(eruptMenus));
            this.sessionService.putByLoginExpire("eruptAuth:menu-view:" + loginModel.getToken(), this.gson.toJson(this.menuService.geneMenuListVo(eruptMenus)));
            this.eruptUserService.saveLoginLog(eruptUser, loginModel.getToken());
        }
        return loginModel;
    }

    @GetMapping(value={"/menu"})
    @ResponseBody
    @EruptRouter(verifyType=EruptRouter.VerifyType.LOGIN, authIndex=0)
    public List<EruptMenuVo> getMenu() {
        return (List)this.sessionService.get("eruptAuth:menu-view:" + this.eruptUserService.getToken(), new TypeToken<List<EruptMenuVo>>(){}.getType());
    }

    @PostMapping(value={"/logout"})
    @ResponseBody
    @EruptRouter(verifyType=EruptRouter.VerifyType.LOGIN, authIndex=0)
    public EruptApiModel logout(HttpServletRequest request) {
        String token = request.getHeader("token");
        this.sessionService.remove("eruptAuth:menu:" + token);
        this.sessionService.remove("eruptAuth:menu-view:" + token);
        this.sessionService.remove("eruptAuth:token:" + token);
        LoginProxy loginProxy = EruptUserService.findEruptLogin();
        if (null != loginProxy) {
            loginProxy.logout(token);
        }
        return EruptApiModel.successApi();
    }

    @PostMapping(value={"/change-pwd"})
    @ResponseBody
    @EruptRouter(verifyType=EruptRouter.VerifyType.LOGIN, authIndex=0)
    public EruptApiModel changePwd(@RequestParam(value="account") String account, @RequestParam(value="pwd") String pwd, @RequestParam(value="newPwd") String newPwd, @RequestParam(value="newPwd2") String newPwd2) {
        return this.eruptUserService.changePwd(account, pwd, newPwd, newPwd2);
    }

    @GetMapping(value={"/token-valid"})
    @ResponseBody
    public boolean tokenValid() {
        return this.sessionService.get(this.eruptUserService.getToken()) != null;
    }

    @GetMapping
    @RequestMapping(value={"/code-img"})
    public void createCode(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("image/jpeg");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        SpecCaptcha captcha = new SpecCaptcha(150, 38, 4);
        this.sessionService.put("eruptAuth:verifyCode:" + IpUtil.getIpAddr(request), captcha.text(), 60L);
        captcha.out((OutputStream)response.getOutputStream());
    }
}

