/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.cache;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.springframework.data.redis.core.StringRedisTemplate;
import xyz.erupt.core.config.GsonFactory;
import xyz.erupt.upms.cache.AbstractEruptCache;

public class RedisEruptCache<V>
extends AbstractEruptCache<V> {
    private final StringRedisTemplate redisTemplate;
    private final Gson gson = GsonFactory.getGson();

    public RedisEruptCache(long timeout, TimeUnit timeUnit, StringRedisTemplate redisTemplate) {
        super(timeout, timeUnit);
        this.redisTemplate = redisTemplate;
    }

    @Override
    public V get(String key, Function<String, V> function) {
        Object v = this.gson.fromJson((String)this.redisTemplate.opsForValue().get((Object)key), new TypeToken<V>(){}.getType());
        if (null == v) {
            v = function.apply(key);
            this.redisTemplate.opsForValue().set((Object)key, (Object)this.gson.toJson(v), this.timeout, this.timeUnit);
        }
        return (V)v;
    }
}

