/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.handler;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;
import xyz.erupt.annotation.fun.ChoiceFetchHandler;
import xyz.erupt.annotation.fun.VLModel;
import xyz.erupt.upms.cache.EruptCacheFactory;
import xyz.erupt.upms.cache.IEruptCache;

@Component
public class SqlChoiceFetchHandler
implements ChoiceFetchHandler {
    @Resource
    private JdbcTemplate jdbcTemplate;
    private final String CACHE_SPACE = SqlChoiceFetchHandler.class.getName() + ":";
    @Resource
    private EruptCacheFactory eruptCacheFactory;
    private IEruptCache<List<VLModel>> dictCache;

    @PostConstruct
    public void init() {
        this.dictCache = this.eruptCacheFactory.getInstance(5000L);
    }

    public List<VLModel> fetch(String[] params) {
        if (null == params || params.length == 0) {
            throw new RuntimeException("SqlChoiceFetchHandler \u2192 params not found");
        }
        return this.dictCache.get(this.CACHE_SPACE + params[0], key -> this.jdbcTemplate.query(params[0], (rs, i) -> {
            if (rs.getMetaData().getColumnCount() == 1) {
                return new VLModel(rs.getString(1), rs.getString(1));
            }
            return new VLModel(rs.getString(1), rs.getString(2));
        }));
    }
}

