/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.looker;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Date;
import javax.annotation.Resource;
import javax.persistence.FetchType;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import org.springframework.stereotype.Service;
import xyz.erupt.annotation.EruptField;
import xyz.erupt.annotation.PreDataProxy;
import xyz.erupt.annotation.config.SkipSerialize;
import xyz.erupt.annotation.fun.DataProxy;
import xyz.erupt.annotation.sub_field.Edit;
import xyz.erupt.annotation.sub_field.EditType;
import xyz.erupt.annotation.sub_field.Readonly;
import xyz.erupt.annotation.sub_field.View;
import xyz.erupt.annotation.sub_field.sub_edit.DateType;
import xyz.erupt.core.exception.EruptWebApiRuntimeException;
import xyz.erupt.jpa.model.BaseModel;
import xyz.erupt.upms.model.EruptUser;
import xyz.erupt.upms.model.EruptUserVo;
import xyz.erupt.upms.service.EruptUserService;

@MappedSuperclass
@PreDataProxy(value=LookerOrg.class)
@Service
public class LookerOrg
extends BaseModel
implements DataProxy<LookerOrg> {
    @ManyToOne
    @EruptField(views={@View(title="\u521b\u5efa\u4eba", column="name"), @View(title="\u6240\u5c5e\u7ec4\u7ec7", column="eruptOrg.name")}, edit=@Edit(title="\u521b\u5efa\u4eba", readonly=@Readonly, type=EditType.REFERENCE_TABLE))
    private EruptUserVo createUser;
    @EruptField(views={@View(title="\u521b\u5efa\u65f6\u95f4")}, edit=@Edit(title="\u521b\u5efa\u65f6\u95f4", readonly=@Readonly, dateType=@DateType(type=DateType.Type.DATE_TIME)))
    private Date createTime;
    @SkipSerialize
    private Date updateTime;
    @SkipSerialize
    @JsonIgnore
    @ManyToOne(fetch=FetchType.LAZY)
    private EruptUserVo updateUser;
    @Resource
    @Transient
    private EruptUserService eruptUserService;

    public String beforeFetch(Class<?> eruptClass) {
        EruptUser eruptUser = this.eruptUserService.getCurrentEruptUser();
        if (eruptUser.getIsAdmin().booleanValue()) {
            return null;
        }
        if (null == eruptUser.getEruptOrg()) {
            throw new EruptWebApiRuntimeException(eruptUser.getName() + " unbounded organization cannot filter data");
        }
        return eruptClass.getSimpleName() + ".createUser.eruptOrg.id = " + eruptUser.getEruptOrg().getId();
    }

    public void beforeAdd(LookerOrg lookerOrg) {
        lookerOrg.setCreateTime(new Date());
        lookerOrg.setCreateUser(new EruptUserVo(this.eruptUserService.getCurrentUid()));
    }

    public void beforeUpdate(LookerOrg lookerOrg) {
        lookerOrg.setUpdateTime(new Date());
        lookerOrg.setUpdateUser(new EruptUserVo(this.eruptUserService.getCurrentUid()));
    }

    public EruptUserVo getCreateUser() {
        return this.createUser;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public EruptUserVo getUpdateUser() {
        return this.updateUser;
    }

    public EruptUserService getEruptUserService() {
        return this.eruptUserService;
    }

    public void setCreateUser(EruptUserVo createUser) {
        this.createUser = createUser;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    @JsonIgnore
    public void setUpdateUser(EruptUserVo updateUser) {
        this.updateUser = updateUser;
    }

    public void setEruptUserService(EruptUserService eruptUserService) {
        this.eruptUserService = eruptUserService;
    }
}

