/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.handler;

import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import xyz.erupt.annotation.fun.PowerHandler;
import xyz.erupt.annotation.fun.PowerObject;
import xyz.erupt.core.invoke.PowerInvoke;
import xyz.erupt.upms.enums.MenuLimitEnum;
import xyz.erupt.upms.service.EruptContextService;
import xyz.erupt.upms.service.EruptSessionService;

@Service
public class UpmsPowerHandler
implements PowerHandler {
    @Resource
    private EruptSessionService eruptSessionService;
    @Resource
    private EruptContextService eruptContextService;

    public void handler(PowerObject power) {
        Optional.ofNullable(this.eruptContextService.getCurrentEruptMenu()).ifPresent(eruptMenu -> {
            this.powerOff(eruptMenu.getPowerOff(), power);
            Optional.of(this.eruptSessionService.get("eruptAuth:role-power:" + this.eruptContextService.getCurrentToken())).ifPresent(it -> this.powerOff(it.toString(), power));
        });
    }

    private void powerOff(String powerStr, PowerObject power) {
        if (StringUtils.isNotBlank((CharSequence)powerStr)) {
            if (powerStr.contains(MenuLimitEnum.NO_ADD.name())) {
                power.setAdd(false);
            }
            if (powerStr.contains(MenuLimitEnum.NO_DELETE.name())) {
                power.setDelete(false);
            }
            if (powerStr.contains(MenuLimitEnum.NO_EDIT.name())) {
                power.setEdit(false);
            }
            if (powerStr.contains(MenuLimitEnum.NO_QUERY.name())) {
                power.setQuery(false);
            }
            if (powerStr.contains(MenuLimitEnum.NO_EXPORT.name())) {
                power.setExport(false);
            }
            if (powerStr.contains(MenuLimitEnum.NO_IMPORT.name())) {
                power.setImportable(false);
            }
        }
    }

    static {
        PowerInvoke.RegisterPowerHandler(UpmsPowerHandler.class);
    }
}

