/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.model;

import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.springframework.stereotype.Component;
import xyz.erupt.annotation.Erupt;
import xyz.erupt.annotation.EruptField;
import xyz.erupt.annotation.EruptI18n;
import xyz.erupt.annotation.fun.FilterHandler;
import xyz.erupt.annotation.sub_erupt.Filter;
import xyz.erupt.annotation.sub_field.Edit;
import xyz.erupt.annotation.sub_field.EditType;
import xyz.erupt.annotation.sub_field.View;
import xyz.erupt.annotation.sub_field.sub_edit.BoolType;
import xyz.erupt.annotation.sub_field.sub_edit.TagsType;
import xyz.erupt.jpa.model.BaseModel;
import xyz.erupt.upms.enums.MenuLimitEnum;
import xyz.erupt.upms.handler.RoleMenuFilter;
import xyz.erupt.upms.model.EruptMenu;
import xyz.erupt.upms.model.EruptUser;
import xyz.erupt.upms.service.EruptUserService;

@Entity
@Table(name="e_upms_role", uniqueConstraints={@UniqueConstraint(columnNames={"code"})})
@Erupt(name="\u7528\u6237\u89d2\u8272", filter={@Filter(conditionHandler=EruptRole.class)})
@EruptI18n
@Component
public class EruptRole
extends BaseModel
implements FilterHandler {
    @EruptField(views={@View(title="\u7f16\u7801")}, edit=@Edit(title="\u7f16\u7801", notNull=true))
    private String code;
    @EruptField(views={@View(title="\u540d\u79f0")}, edit=@Edit(title="\u540d\u79f0", notNull=true))
    private String name;
    @EruptField(views={@View(title="\u72b6\u6001")}, edit=@Edit(title="\u72b6\u6001", type=EditType.BOOLEAN, notNull=true, boolType=@BoolType(trueText="\u542f\u7528", falseText="\u7981\u7528")))
    private Boolean status = true;
    @EruptField(views={@View(title="\u64cd\u4f5c\u6743\u9650", template="value&&value.replace(/\\|/g,'<span class=\"text-red\"> | </span>')")}, edit=@Edit(title="\u64cd\u4f5c\u6743\u9650", type=EditType.TAGS, tagsType=@TagsType(fetchHandler={MenuLimitEnum.MenuLimitFetch.class}, allowExtension=false)))
    private String powerOff;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="e_upms_role_menu", joinColumns={@JoinColumn(name="role_id", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="menu_id", referencedColumnName="id")})
    @EruptField(views={@View(title="\u83dc\u5355\u6743\u9650")}, edit=@Edit(filter={@Filter(conditionHandler=RoleMenuFilter.class)}, title="\u83dc\u5355\u6743\u9650", type=EditType.TAB_TREE))
    private Set<EruptMenu> menus;
    @Transient
    @Resource
    private EruptUserService eruptUserService;

    public String filter(String condition, String[] params) {
        EruptUser eruptUser = this.eruptUserService.getCurrentEruptUser();
        if (eruptUser.getIsAdmin().booleanValue()) {
            return null;
        }
        Set roles = eruptUser.getRoles().stream().map(it -> it.getId().toString()).collect(Collectors.toSet());
        return String.format("id in (%s)", String.join((CharSequence)",", roles));
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getStatus() {
        return this.status;
    }

    public String getPowerOff() {
        return this.powerOff;
    }

    public Set<EruptMenu> getMenus() {
        return this.menus;
    }

    public EruptUserService getEruptUserService() {
        return this.eruptUserService;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStatus(Boolean status) {
        this.status = status;
    }

    public void setPowerOff(String powerOff) {
        this.powerOff = powerOff;
    }

    public void setMenus(Set<EruptMenu> menus) {
        this.menus = menus;
    }

    public void setEruptUserService(EruptUserService eruptUserService) {
        this.eruptUserService = eruptUserService;
    }
}

