/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.upms.service;

import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.data.redis.core.BoundHashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import xyz.erupt.core.config.GsonFactory;
import xyz.erupt.core.prop.EruptProp;

@Component
public class EruptSessionService {
    @Resource
    private EruptProp eruptProp;
    @Resource
    private HttpServletRequest request;
    @Resource
    private StringRedisTemplate stringRedisTemplate;
    private final Gson gson = GsonFactory.getGson();

    public void put(String key, String str, long timeout) {
        this.put(key, str, timeout, TimeUnit.MINUTES);
    }

    public void put(String key, String str, long timeout, TimeUnit timeUnit) {
        if (this.eruptProp.isRedisSession()) {
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)str, timeout, timeUnit);
        } else {
            this.request.getSession().setAttribute(key, (Object)str);
        }
    }

    public void remove(String key) {
        if (this.eruptProp.isRedisSession()) {
            this.stringRedisTemplate.delete((Object)key);
        } else {
            this.request.getSession().removeAttribute(key);
        }
    }

    public Object get(String key) {
        if (this.eruptProp.isRedisSession()) {
            return this.stringRedisTemplate.opsForValue().get((Object)key);
        }
        return this.request.getSession().getAttribute(key);
    }

    public <T> T get(String key, Type type) {
        if (this.eruptProp.isRedisSession()) {
            if (null == this.get(key)) {
                return null;
            }
            return (T)this.gson.fromJson(this.get(key).toString(), type);
        }
        return (T)this.gson.fromJson(this.request.getSession().getAttribute(key).toString(), type);
    }

    public void putMap(String key, Map<String, Object> map, long expire) {
        if (this.eruptProp.isRedisSession()) {
            BoundHashOperations boundHashOperations = this.stringRedisTemplate.boundHashOps((Object)key);
            map.replaceAll((k, v) -> this.gson.toJson(v));
            boundHashOperations.putAll(map);
            boundHashOperations.expire(expire, TimeUnit.MINUTES);
        } else {
            this.request.getSession().setAttribute(key, map);
        }
    }

    public <T> T getMapValue(String key, String mapKey, Class<T> type) {
        if (this.eruptProp.isRedisSession()) {
            Object obj = this.stringRedisTemplate.boundHashOps((Object)key).get((Object)mapKey);
            if (null == obj) {
                return null;
            }
            return (T)this.gson.fromJson(obj.toString(), type);
        }
        Map map = (Map)this.request.getSession().getAttribute(key);
        if (null == map) {
            return null;
        }
        return (T)map.get(mapKey);
    }
}

