package xyz.gunanyi.currency.annotation;


import xyz.gunanyi.currency.entity.SysOperationLog;

import java.lang.annotation.*;

/**
 * 自定义操作日志注解
 * @author 曾博旺
 */

@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface OperLog {
    /**
     * 操作模块
     * @return null
     */
    String operModul() default "";

    /**
     * 操作类型
     * @return null
     */
    String operType() default "";

    /**
     * 操作说明
     * @return null
     */
    String operDesc() default "";

    /**
     *  ===========================更改前数据类型
     */
    /**
     * 是否记录更改前数据
     * @return null
     */
    boolean isPreData() default false;

    /**
     * 操作类
     * @return null
     */
    Class clz() default SysOperationLog.class;

    /**
     * 表名
     * @return null
     */
    String table() default "";

    /**
     * 唯一标识字段
     * @return null
     */
    String onlyId() default "";
}
