package xyz.gunanyi.currency.utils;

import xyz.gunanyi.currency.annotation.PdfGenerate;
import xyz.gunanyi.currency.entity.PdfEntity;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * @author: Sunyah
 * pdftable生成（搭配注解（PdfGenerate））
 */
public class PdfTableGenerate {

    /**
     * 获取到表格的标题、内容、文字大小、单元格
     *
     * @param pdfPTable  表格的标题
     * @param obj 对象
     * @return PdfPTable
     */
    public static PdfPTable pdfPTableGenerate(PdfPTable pdfPTable, Object obj) {
        Map<String, PdfEntity> pdfEntityMap = new LinkedHashMap<String, PdfEntity>();
        //得到class
        Class cls = obj.getClass();
        //得到所有属性
        Field[] fields = cls.getDeclaredFields();
        for (int i = 0; i < fields.length; i++) {//遍历
            try {
                //匹配是否为静态常量
                if (Modifier.isStatic(fields[i].getModifiers())) {
                    continue;
                }
                //得到属性
                Field field = fields[i];
                //打开私有访问
                field.setAccessible(true);
                //获取属性
                String name = field.getName();
                //获取属性值
                Object value = field.get(obj);
                //一个个赋值

                PdfGenerate annotation = field.getAnnotation(PdfGenerate.class);
                if (annotation != null) {
                    PdfEntity pdfEntity = new PdfEntity();
                    pdfEntity.setTitle(annotation.value());
                    pdfEntity.setContent(value == "" || value == null ? "--" : value.toString());
                    pdfEntity.setContentCell(annotation.contentCell());
                    pdfEntity.setTitleCell(annotation.titleCell());
                    pdfEntity.setTitleSize(annotation.titleSize());
                    pdfEntity.setContentSize(annotation.contentSize());
                    pdfEntityMap.put(annotation.value(), pdfEntity);
                }

            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }

        return getPdfPTable(pdfPTable, pdfEntityMap);
    }

    /**
     * 获取PdfPTable
     * @param pdfPTable pdfPTable
     * @param pdfEntityMap pdfEntityMap
     * @return PdfPTable
     */
    public static PdfPTable getPdfPTable(PdfPTable pdfPTable, Map<String, PdfEntity> pdfEntityMap) {
        for (String key : pdfEntityMap.keySet()) {
            PdfEntity pdfEntity = pdfEntityMap.get(key);
            pdfPTable.addCell(createCell(pdfEntity.getTitle(), pdfEntity.getTitleCell(), pdfEntity.getTitleSize()));
            pdfPTable.addCell(createCell(pdfEntity.getContent(), pdfEntity.getContentCell(), pdfEntity.getContentSize()));
        }
        return pdfPTable;
    }

    public static PdfPCell createCell(String value, int colSpan, int size) {
        BaseFont bf = null;
        try {
            bf = BaseFont.createFont("STSong-Light", "UniGB-UCS2-H", false, false, null, null);
        } catch (DocumentException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }

        Font fontChinese5 = new Font(bf, size);
        PdfPCell cell = new PdfPCell();
        cell.setColspan(colSpan);
        cell.setPhrase(new Phrase(value, fontChinese5));
        //设置水平居中
        cell.setHorizontalAlignment(Element.ALIGN_CENTER);
        //设置垂直居中
        cell.setVerticalAlignment(Element.ALIGN_MIDDLE);

        return cell;
    }

}
