package xyz.gunanyi.currency.utils;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import xyz.gunanyi.currency.annotation.TableAlias;
import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

/**
 * @author: Sunyah
 * 反射赋值修改
 */
@Slf4j
public class ReflexAssig {
    /**
     * 得到属性值给不为空的属性赋值 where默认id
     * @param updateWrapper updateWrapper
     * @param obj obj
     * @return UpdateWrapper
     */
    public static UpdateWrapper readAttributeValue(UpdateWrapper updateWrapper, Object obj) {
        try {
            NetFrameSetFiled.setFrameFiled(obj);
        } catch (Exception e) {
            log.error("此对象有非.net框架固定字段");
        }
        String nameVlues = "";
        //得到class
        Class cls = obj.getClass();
        //得到所有属性
        Field[] fields = cls.getDeclaredFields();
        for (int i = 0; i < fields.length; i++) {//遍历
            try {
                //匹配是否为静态常量
                if (Modifier.isStatic(fields[i].getModifiers())) {
                    continue;
                }
                //得到属性
                Field field = fields[i];
                //打开私有访问
                field.setAccessible(true);
                //获取属性
                String name = field.getName();
                //获取属性值
                Object value = field.get(obj);
                //一个个赋值
//                nameVlues += field.getName() + ":" + value + ",";
                if (field.getName().equals("id")) {
                    updateWrapper.eq(field.getName(), value);
                    continue;
                }
                //如果TableField为false不修改
                TableField annotation = field.getAnnotation(TableField.class);

                if (value != null) {
                    if (annotation == null || annotation.exist()) {
                        updateWrapper.set(field.getName(), value);
                    }
                }
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return updateWrapper;
    }


    public static QueryWrapper queryWrapperStatic = new QueryWrapper();

    /**
     *
     * 组装QueryWrapper（需加注解才会赋值：@TableAlias("表别名")）
     * 如有其他未加注解的参数请先调用此方法先得到QueryWrapper
     *
     * @param queryWrapper queryWrapper
     * @param obj obj
     * @return QueryWrapper
     * @throws IllegalAccessException IllegalAccessException
     */
    public static QueryWrapper assembleQueryWrapper(QueryWrapper queryWrapper, Object obj) throws IllegalAccessException {
        queryWrapperStatic = queryWrapper;
        if (ObjectUtil.isNull(obj)) {
            throw new NullPointerException("组装对象不能为空");
        }
        //得到class
        Class cls = obj.getClass();
        //得到所有属性
        Field[] fields = cls.getDeclaredFields();
        for (Field field : fields) {
            //匹配是否为静态常量
            if (Modifier.isStatic(field.getModifiers())) {
                continue;
            }//打开私有访问
            field.setAccessible(true);
            //获取属性
            String name = field.getName();
            //获取属性值
            Object value = null;
            try {
                value = field.get(obj);
            } catch (IllegalAccessException e) {
                throw new IllegalAccessException("值获取失败");
            }
            //一个个赋值
            //如果TableField为false不修改
            TableAlias annotation = field.getAnnotation(TableAlias.class);

            if (value != null) {
                if (annotation != null) {
                    if (StringUtils.isNotBlank(annotation.field()) ) {
                        equalsSymbol(annotation.fuHao(), annotation.value() + "." + annotation.field(), value);
                    }
                    if (StringUtils.isBlank(annotation.field())) {
                        equalsSymbol(annotation.fuHao(), annotation.value() + "." + name, value);
                    }
//                        queryWrapperStatic.eq(annotation.value() + "." + field.getName(), value);
                }
//                if (annotation == null) {
//                     equalsSymbol(annotation.fuHao(), name, value);
//                }
            }
        }
        return queryWrapperStatic;
    }

    /**
     *  给UpdateWrapper设置值不带条件（object有值的情况）
     *  id除外、TableField为false除外
     * @param updateWrapper updateWrapper
     * @param obj obj
     * @return UpdateWrapper
     */
    public static UpdateWrapper setUpdateWrapper(UpdateWrapper updateWrapper, Object obj) {
        String nameVlues = "";
        //得到class
        Class cls = obj.getClass();
        //得到所有属性
        Field[] fields = cls.getDeclaredFields();
        for (int i = 0; i < fields.length; i++) {//遍历
            try {
                //匹配是否为静态常量
                if (Modifier.isStatic(fields[i].getModifiers())) {
                    continue;
                }
                //得到属性
                Field field = fields[i];
                //打开私有访问
                field.setAccessible(true);
                //获取属性
                String name = field.getName();
                //获取属性值
                Object value = field.get(obj);
                //一个个赋值
//                nameVlues += field.getName() + ":" + value + ",";
                if (field.getName().equals("id")) {
//                    updateWrapper.eq(field.getName(), value);
                    continue;
                }
                //如果TableField为false不修改
                TableField annotation = field.getAnnotation(TableField.class);

                if (value != null) {
                    if (annotation == null || annotation.exist()) {
                        updateWrapper.set(field.getName(), value);
                    }
                }
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return updateWrapper;
    }

    public static void equalsSymbol(String symbol, String field, Object value) {

        if ("=".equals(symbol) || symbol == "=") {
            queryWrapperStatic.eq(field, value);
        }
        if ("!=".equals(symbol) || symbol == "!=") {
            queryWrapperStatic.ne(field, value);
        }
        if (">".equals(symbol) || symbol == ">") {
            queryWrapperStatic.gt(field, value);
        }
        if ("<".equals(symbol) || symbol == "<") {
            queryWrapperStatic.lt(field, value);
        }
        if (">=".equals(symbol) || symbol == ">=") {
            queryWrapperStatic.ge(field, value);
        }
        if ("<=".equals(symbol) || symbol == "<=") {
            queryWrapperStatic.le(field, value);
        }
        if ("like".equals(symbol) || symbol == "like") {
            queryWrapperStatic.like(field, value);
        }
        if ("notLike".equals(symbol) || symbol == "notLike") {
            queryWrapperStatic.notLike(field, value);
        }
        if ("isNull".equals(symbol) || symbol == "isNull") {
            queryWrapperStatic.isNull(field);
        }
        if ("isNotNull".equals(symbol) || symbol == "isNotNull") {
            queryWrapperStatic.isNotNull(value);
        }
        if ("in".equals(symbol) || symbol == "in") {
            queryWrapperStatic.in(field, value);
        }
        if ("notIn".equals(symbol) || symbol == "notIn") {
            queryWrapperStatic.notIn(field, value);
        }

    }

    /**
     * 合并对象
     * 以第一个实体类为主，如果第一个的实体类某个字段为空，则会吧第二个实体类的值取过来进行赋值，
     * 如果不为空的则不作改变
     *
     * @param sourceBean  目标对象
     * @param targetBean  需要合并的对象
     * @return Object
     */
    public static Object combineCore(Object sourceBean, Object targetBean) {
        Class sourceBeanClass = sourceBean.getClass();
        Class targetBeanClass = targetBean.getClass();

        Field[] sourceFields = sourceBeanClass.getDeclaredFields();
        Field[] targetFields = sourceBeanClass.getDeclaredFields();
        for (int i = 0; i < sourceFields.length; i++) {

            Field sourceField = sourceFields[i];
            Field targetField = targetFields[i];
            //匹配是否为静态常量
            if (Modifier.isStatic(sourceField.getModifiers()) || Modifier.isStatic(targetField.getModifiers())) {
                continue;
            }
            sourceField.setAccessible(true);
            targetField.setAccessible(true);
            try {
                if (!(sourceField.get(sourceBean) == null)) {
                    targetField.set(targetBean, sourceField.get(sourceBean));
                }
            } catch (IllegalArgumentException | IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return targetBean;
    }
}
