/*
 * Decompiled with CFR 0.152.
 */
package xyz.gunanyi.currency.aspect;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import xyz.gunanyi.currency.annotation.OperLog;
import xyz.gunanyi.currency.entity.SysOperationLog;
import xyz.gunanyi.currency.service.ISysOperationLogService;
import xyz.gunanyi.currency.utils.CusAccessObjectUtil;
import xyz.gunanyi.currency.utils.IpAndAddrUtil;

@Aspect
@Component
public class OperLogAspect {
    private static final Logger log = LoggerFactory.getLogger(OperLogAspect.class);
    private String operVer = System.getProperty("java.version");
    @Autowired
    private ISysOperationLogService sysOperationLogService;

    @Pointcut(value="@annotation(xyz.gunanyi.currency.annotation.OperLog)")
    public void excudeService() {
    }

    @Around(value="excudeService()")
    public Object saveOperLog(ProceedingJoinPoint joinPoint) {
        Object result = null;
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = (HttpServletRequest)requestAttributes.resolveReference("request");
        SysOperationLog operlog = new SysOperationLog();
        try {
            MethodSignature signature = (MethodSignature)joinPoint.getSignature();
            Method method = signature.getMethod();
            JSONObject rtnObj = new JSONObject();
            Map<String, String> rtnMap = this.converMap(request.getParameterMap());
            if (rtnMap.size() == 0) {
                rtnObj = this.getPara((JoinPoint)joinPoint);
            } else {
                String json = JSON.toJSONString(rtnMap);
                rtnObj = JSON.parseObject((String)json);
            }
            String params = JSON.toJSONString((Object)rtnObj);
            OperLog opLog = method.getAnnotation(OperLog.class);
            if (opLog != null) {
                String operModul = opLog.operModul();
                String operType = opLog.operType();
                String operDesc = opLog.operDesc();
                operlog.setOperModul(operModul);
                operlog.setOperType(operType);
                operlog.setOperDesc(operDesc);
                try {
                    operlog.setBrowser(IpAndAddrUtil.getBrowserName(request) + "\t\uff1a" + IpAndAddrUtil.getBrowserVersion(request));
                    operlog.setIpaddress(IpAndAddrUtil.getIp(request));
                    operlog.setOs(IpAndAddrUtil.getOsName(request));
                }
                catch (Exception e) {
                    log.error("\u5730\u5740\u83b7\u53d6\u5931\u8d25");
                    e.printStackTrace();
                }
                if (opLog.isPreData()) {
                    Class clz = opLog.clz();
                    String table = opLog.table();
                    String onlyId = opLog.onlyId();
                    String operData = this.addPerData(clz, table, onlyId, rtnObj);
                    operlog.setOperData(operData);
                    operlog.setOperationTable(table);
                }
            }
            String className = joinPoint.getTarget().getClass().getName();
            String methodName = method.getName();
            methodName = className + "." + methodName;
            operlog.setOperMethod(methodName);
            operlog.setOperRequParam(params);
            try {
                Object[] args = joinPoint.getArgs();
                result = joinPoint.proceed(args);
                operlog.setOperRespParam(JSON.toJSONString((Object)result));
            }
            catch (Throwable throwable) {
                log.error("\u83b7\u53d6\u9519\u8bef\u8fd4\u56de\u503c");
            }
            operlog.setOperIp(CusAccessObjectUtil.getIpAddress(request));
            operlog.setOperUri(request.getRequestURI());
            operlog.setOperVer(this.operVer);
            this.sysOperationLogService.save(operlog);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Object[] args = joinPoint.getArgs();
        return result;
    }

    private String addPerData(Class clz, String table, String onlyId, JSONObject parm) {
        if (StringUtils.isBlank((CharSequence)table)) {
            TableName tableName = clz.getAnnotation(TableName.class);
            table = tableName.value();
        }
        String onlyIdValue = parm.getString(onlyId);
        List<Map<String, Object>> obj = this.sysOperationLogService.executeSql(table, onlyId, onlyIdValue);
        return JSON.toJSONString(obj);
    }

    public Map<String, String> converMap(Map<String, String[]> paramMap) {
        HashMap<String, String> rtnMap = new HashMap<String, String>();
        for (String key : paramMap.keySet()) {
            rtnMap.put(key, paramMap.get(key)[0]);
        }
        return rtnMap;
    }

    public JSONObject getPara(JoinPoint joinPoint) {
        Object[] args = joinPoint.getArgs();
        Object arg = args[0];
        String s = JSONObject.toJSONString((Object)arg);
        JSONObject afterJson = JSONObject.parseObject((String)s);
        return afterJson;
    }

    private String getRequestPayload(HttpServletRequest req) {
        StringBuilder sb = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            ServletInputStream inputStream = req.getInputStream();
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream, "UTF-8"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try (BufferedReader reader = bufferedReader;){
            int len;
            char[] buff = new char[1024];
            while ((len = reader.read(buff)) != -1) {
                sb.append(buff, 0, len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public String stackTraceToString(String exceptionName, String exceptionMessage, StackTraceElement[] elements) {
        StringBuffer strbuff = new StringBuffer();
        for (StackTraceElement stet : elements) {
            strbuff.append(stet + "\n");
        }
        String message = exceptionName + ":" + exceptionMessage + "\n\t" + strbuff.toString();
        return message;
    }
}

